/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.wsdl.Definition;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;

public class JavaBuildFileWriter
extends JavaWriter {
    protected Definition definition;
    protected SymbolTable symbolTable;

    public JavaBuildFileWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, "build");
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    protected String getFileName() {
        String dir = this.emitter.getOutputDir();
        return dir + "/build.xml";
    }

    protected void writeFileBody(PrintWriter out) throws IOException {
        out.write("<?xml version=\"1.0\"?>\n");
        out.write("<project basedir=\".\" default=\"jar\">\n");
        out.write("\t<property name=\"src\" location=\".\"/>\n");
        out.write("\t<property name=\"build.classes\" location=\"classes\"/>\n");
        out.write("\t<path id=\"classpath\">\n");
        StringTokenizer tok = this.getClasspathComponets();
        while (tok.hasMoreTokens()) {
            out.write("\t\t<pathelement location=\"" + tok.nextToken() + "\"/>\n");
        }
        out.write("\t</path>\n");
        out.write("\t<target name=\"compile\">\n");
        out.write("\t   <mkdir dir=\"${build.classes}\"/>\n");
        out.write("\t\t<javac destdir=\"${build.classes}\" debug=\"on\">\n");
        out.write("\t\t\t<classpath refid=\"classpath\" />\n");
        out.write("\t\t\t<src path=\"${src}\"/>\n");
        out.write("\t\t</javac>\n");
        out.write("\t</target>\n");
        out.write("\t<target name=\"jar\" depends=\"compile\">\n");
        out.write("        <copy todir=\"${build.classes}\">\n");
        out.write("            <fileset dir=\".\" casesensitive=\"yes\" >\n");
        out.write("                <include name=\"**/*.wsdd\"/>\n");
        out.write("            </fileset>\n");
        out.write("        </copy>\n");
        out.write("\t\t<jar jarfile=\"" + this.getJarFileName(this.symbolTable.getWSDLURI()) + ".jar\" basedir=\"${build.classes}\" >\n");
        out.write("\t\t<include name=\"**\" />\n");
        out.write("\t\t<manifest>\n");
        out.write("\t\t\t<section name=\"org/apache/ws4j2ee\">\n");
        out.write("\t\t\t<attribute name=\"Implementation-Title\" value=\"Apache Axis\"/>\n");
        out.write("\t\t\t<attribute name=\"Implementation-Vendor\" value=\"Apache Web Services\"/>\n");
        out.write("\t\t\t</section>\n");
        out.write("\t\t</manifest>\n");
        out.write("\t\t</jar>\n");
        out.write("\t\t<delete dir=\"${build.classes}\"/>\n");
        out.write("\t</target>\n");
        out.write("</project>\n");
        out.close();
    }

    private StringTokenizer getClasspathComponets() {
        String classpath = System.getProperty("java.class.path");
        String spearator = ";";
        if (classpath.indexOf(59) < 0) {
            spearator = ":";
        }
        return new StringTokenizer(classpath, spearator);
    }

    private String getJarFileName(String wsdlFile) {
        int index = 0;
        index = wsdlFile.lastIndexOf("/");
        if (index > 0) {
            wsdlFile = wsdlFile.substring(index + 1);
        }
        return wsdlFile.substring(0, wsdlFile.indexOf(46));
    }

    public void generate() throws IOException {
        if (this.emitter.isBuildFileWanted()) {
            super.generate();
        }
    }
}

