/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.DeserializationContextImpl;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.enum.Style;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.NamedNodeMapImpl;
import org.apache.axis.message.NodeListImpl;
import org.apache.axis.message.NullAttributes;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SAXOutputter;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.message.Text;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MessageElement
implements SOAPElement,
Serializable,
NodeList,
Cloneable {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$message$MessageElement == null ? (class$org$apache$axis$message$MessageElement = MessageElement.class$("org.apache.axis.message.MessageElement")) : class$org$apache$axis$message$MessageElement).getName());
    private static final Mapping enc11Mapping = new Mapping("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC");
    private static final Mapping enc12Mapping = new Mapping("http://www.w3.org/2003/05/soap-encoding", "SOAP-ENC");
    protected String name;
    protected String prefix;
    protected String namespaceURI;
    protected transient Attributes attributes = NullAttributes.singleton;
    protected String id;
    protected String href;
    protected boolean _isRoot = true;
    protected SOAPEnvelope message = null;
    protected boolean _isDirty = false;
    protected transient DeserializationContext context;
    protected transient QName typeQName = null;
    protected Vector qNameAttrs = null;
    protected transient SAX2EventRecorder recorder = null;
    protected int startEventIndex = 0;
    protected int startContentsIndex = 0;
    protected int endEventIndex = -1;
    protected Element elementRep = null;
    protected org.w3c.dom.Text textRep = null;
    protected MessageElement parent = null;
    public ArrayList namespaces = null;
    protected String encodingStyle = null;
    private Object objectValue = null;
    Deserializer fixupDeserializer;
    private ArrayList children = null;
    protected SOAPPart soapPart = null;
    static /* synthetic */ Class class$org$apache$axis$message$MessageElement;

    public MessageElement() {
    }

    public MessageElement(String namespace, String localPart) {
        this.namespaceURI = namespace;
        this.name = localPart;
    }

    public MessageElement(String localPart, String prefix, String namespace) {
        this.namespaceURI = namespace;
        this.name = localPart;
        this.prefix = prefix;
        this.addMapping(new Mapping(namespace, prefix));
    }

    public MessageElement(Name eltName) {
        this(eltName.getLocalName(), eltName.getPrefix(), eltName.getURI());
    }

    public MessageElement(String namespace, String localPart, Object value) {
        this(namespace, localPart);
        this.objectValue = value;
    }

    public MessageElement(QName name, Object value) {
        this(name.getNamespaceURI(), name.getLocalPart());
        this.objectValue = value;
    }

    public MessageElement(Element elem) {
        this.elementRep = elem;
        this.namespaceURI = elem.getNamespaceURI();
        this.name = elem.getLocalName();
    }

    public MessageElement(org.w3c.dom.Text text) {
        this.textRep = text;
        this.namespaceURI = text.getNamespaceURI();
        this.name = text.getLocalName();
    }

    public MessageElement(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("newElem00", super.toString(), "{" + prefix + "}" + localPart));
            for (int i = 0; attributes != null && i < attributes.getLength(); ++i) {
                log.debug((Object)("  " + attributes.getQName(i) + " = '" + attributes.getValue(i) + "'"));
            }
        }
        this.namespaceURI = namespace;
        this.name = localPart;
        this.prefix = prefix;
        this.context = context;
        this.startEventIndex = context.getStartOfMappingsPos();
        this.setNSMappings(context.getCurrentNSMappings());
        this.recorder = context.getRecorder();
        if (attributes != null && attributes.getLength() > 0) {
            TypeMapping tm;
            MessageContext mc;
            this.attributes = attributes;
            this.typeQName = context.getTypeFromAttributes(namespace, localPart, attributes);
            String rootVal = attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "root");
            if (rootVal != null) {
                this._isRoot = rootVal.equals("1");
            }
            this.id = attributes.getValue("id");
            if (this.id != null) {
                context.registerElementByID(this.id, this);
                if (this.recorder == null) {
                    this.recorder = new SAX2EventRecorder();
                    context.setRecorder(this.recorder);
                }
            }
            SOAPConstants sc = (mc = context.getMessageContext()) != null ? mc.getSOAPConstants() : SOAPConstants.SOAP11_CONSTANTS;
            this.href = attributes.getValue(sc.getAttrHref());
            if (attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "arrayType") != null) {
                this.typeQName = Constants.SOAP_ARRAY;
            }
            this.encodingStyle = attributes.getValue(sc.getEncodingURI(), "encodingStyle");
            if ("http://www.w3.org/2003/05/soap-envelope/encoding/none".equals(this.encodingStyle)) {
                this.encodingStyle = null;
            }
            if (this.encodingStyle != null && sc.equals(SOAPConstants.SOAP12_CONSTANTS) && mc.getOperationStyle() != Style.MESSAGE && ((tm = mc.getTypeMappingRegistry().getTypeMapping(this.encodingStyle)) == null || tm.equals(mc.getTypeMappingRegistry().getDefaultTypeMapping()))) {
                AxisFault badEncodingFault = new AxisFault(Constants.FAULT_SOAP12_DATAENCODINGUNKNOWN, "bad encoding style", null, null);
                throw badEncodingFault;
            }
        }
    }

    public void setFixupDeserializer(Deserializer dser) {
        this.fixupDeserializer = dser;
    }

    public Deserializer getFixupDeserializer() {
        return this.fixupDeserializer;
    }

    public void setEndIndex(int endIndex) {
        this.endEventIndex = endIndex;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean dirty) {
        this._isDirty = dirty;
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public String getID() {
        return this.id;
    }

    public String getHref() {
        return this.href;
    }

    public Attributes getAttributesEx() {
        return this.attributes;
    }

    public Node getFirstChild() {
        if (this.children != null && !this.children.isEmpty()) {
            return (Node)this.children.get(0);
        }
        return null;
    }

    public Node getLastChild() {
        ArrayList children = this.getChildren();
        if (children != null) {
            return (Node)children.get(children.size() - 1);
        }
        return null;
    }

    public Node getNextSibling() {
        SOAPElement parent = this.getParentElement();
        if (parent == null) {
            return null;
        }
        Iterator iter = parent.getChildElements();
        Node nextSibling = null;
        while (iter.hasNext()) {
            if (!iter.next().equals(this)) continue;
            if (iter.hasNext()) {
                return (Node)iter.next();
            }
            return null;
        }
        return nextSibling;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public Node getPreviousSibling() {
        SOAPElement parent = this.getParentElement();
        Iterator iter = parent.getChildElements();
        Node previousSibling = null;
        while (iter.hasNext()) {
            if (!iter.next().equals(this)) continue;
            return previousSibling;
        }
        return previousSibling;
    }

    public Node cloneNode(boolean deep) {
        try {
            MessageElement clonedSelf = (MessageElement)this.clonning();
            if (deep && this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    MessageElement child = (MessageElement)this.children.get(i);
                    if (child == null) continue;
                    MessageElement clonedChild = (MessageElement)((Object)child.cloneNode(deep));
                    clonedChild.setParent(clonedSelf);
                    clonedChild.setOwnerDocument(this.soapPart);
                }
            }
            return clonedSelf;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Object clonning() throws CloneNotSupportedException {
        try {
            MessageElement clonedME = null;
            clonedME = (MessageElement)this.clone();
            clonedME.setName(this.name);
            clonedME.setNamespaceURI(this.namespaceURI);
            clonedME.setPrefix(this.prefix);
            clonedME.setAllAttributes(new AttributesImpl(this.attributes));
            clonedME.namespaces = new ArrayList();
            if (this.namespaces != null) {
                for (int i = 0; i < this.namespaces.size(); ++i) {
                    Mapping namespace = (Mapping)this.namespaces.get(i);
                    clonedME.addNamespaceDeclaration(namespace.getPrefix(), namespace.getNamespaceURI());
                }
            }
            clonedME.detachAllChildren();
            clonedME.setParent(null);
            clonedME.setDirty(this._isDirty);
            if (this.encodingStyle != null) {
                clonedME.setEncodingStyle(new String(this.encodingStyle));
            }
            clonedME.setRecorder(this.recorder);
            return clonedME;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setAllAttributes(Attributes attrs) {
        this.attributes = attrs;
    }

    public void detachAllChildren() {
        this.children = new ArrayList();
    }

    public NodeList getChildNodes() {
        return this;
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(newChild);
        return newChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        int position;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if ((position = this.children.indexOf(oldChild)) < 0) {
            throw new DOMException(8, "MessageElement Not found");
        }
        this.children.remove(position);
        return oldChild;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        int position;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if ((position = this.children.indexOf(refChild)) < 0) {
            position = 0;
        }
        this.children.add(position, newChild);
        return newChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        int position;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if ((position = this.children.indexOf(oldChild)) < 0) {
            throw new DOMException(8, "MessageElement Not found");
        }
        this.children.remove(position);
        this.children.add(position, newChild);
        return oldChild;
    }

    public Attributes getCompleteAttributes() {
        if (this.namespaces == null) {
            return this.attributes;
        }
        AttributesImpl attrs = null;
        attrs = this.attributes == NullAttributes.singleton ? new AttributesImpl() : new AttributesImpl(this.attributes);
        Iterator iterator = this.namespaces.iterator();
        while (iterator.hasNext()) {
            Mapping mapping = (Mapping)iterator.next();
            String prefix = mapping.getPrefix();
            String nsURI = mapping.getNamespaceURI();
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, nsURI, "CDATA");
        }
        return attrs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QName getQName() {
        return new QName(this.namespaceURI, this.name);
    }

    public void setQName(QName qName) {
        this.name = qName.getLocalPart();
        this.namespaceURI = qName.getNamespaceURI();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(6, "Cannot use TextNode.set in " + this);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Document getOwnerDocument() {
        return this.soapPart;
    }

    public NamedNodeMap getAttributes() {
        this.makeAttributesEditable();
        return this.convertAttrSAXtoDOM(this.attributes);
    }

    private NamedNodeMap convertAttrSAXtoDOM(Attributes saxAttr) {
        try {
            Document doc = XMLUtils.newDocument();
            AttributesImpl saxAttrs = (AttributesImpl)saxAttr;
            NamedNodeMapImpl domAttributes = new NamedNodeMapImpl();
            for (int i = 0; i < saxAttrs.getLength(); ++i) {
                Attr attr;
                String uri = saxAttrs.getURI(i);
                String qname = saxAttrs.getQName(i);
                String value = saxAttrs.getValue(i);
                if (uri != null && uri.trim().length() > 0) {
                    if (uri.equals("intentionalNullURI")) {
                        uri = null;
                    }
                    attr = doc.createAttributeNS(uri, qname);
                    attr.setValue(value);
                    domAttributes.setNamedItemNS(attr);
                    continue;
                }
                attr = doc.createAttribute(qname);
                attr.setValue(value);
                domAttributes.setNamedItem(attr);
            }
            return domAttributes;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public short getNodeType() {
        if (this.textRep != null) {
            return 3;
        }
        return 1;
    }

    public void normalize() {
    }

    public boolean hasAttributes() {
        return this.attributes.getLength() > 0;
    }

    public boolean hasChildNodes() {
        return this.children.size() > 0;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getNodeName() {
        return this.prefix != null ? this.prefix + ":" + this.name : this.name;
    }

    public String getNodeValue() throws DOMException {
        throw new DOMException(6, "Cannot use TextNode.get in " + this);
    }

    public void setNamespaceURI(String nsURI) {
        this.namespaceURI = nsURI;
    }

    public QName getType() {
        MessageElement referent;
        if (this.typeQName == null && this.href != null && this.context != null && (referent = this.context.getElementByID(this.href)) != null) {
            this.typeQName = referent.getType();
        }
        return this.typeQName;
    }

    public void setType(QName qname) {
        this.typeQName = qname;
    }

    public SAX2EventRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(SAX2EventRecorder rec) {
        this.recorder = rec;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            if (this.parent == null) {
                return "";
            }
            return this.parent.getEncodingStyle();
        }
        return this.encodingStyle;
    }

    public void removeContents() {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                try {
                    ((MessageElement)this.children.get(i)).setParent(null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.children.clear();
        }
    }

    public Iterator getVisibleNamespacePrefixes() {
        Iterator mine;
        Iterator parentsPrefixes;
        Vector prefixes = new Vector();
        if (this.parent != null && (parentsPrefixes = this.parent.getVisibleNamespacePrefixes()) != null) {
            while (parentsPrefixes.hasNext()) {
                prefixes.add(parentsPrefixes.next());
            }
        }
        if ((mine = this.getNamespacePrefixes()) != null) {
            while (mine.hasNext()) {
                prefixes.add(mine.next());
            }
        }
        return prefixes.iterator();
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (encodingStyle == null) {
            encodingStyle = "";
        }
        this.encodingStyle = encodingStyle;
        if (encodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            this.addMapping(enc11Mapping);
        } else if (encodingStyle.equals("http://www.w3.org/2003/05/soap-encoding")) {
            this.addMapping(enc12Mapping);
        }
    }

    private MessageElement getParent() {
        return this.parent;
    }

    private void setParent(MessageElement parent) throws SOAPException {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void addChild(MessageElement el) throws SOAPException {
        if (this.objectValue != null) {
            SOAPException exc = new SOAPException(Messages.getMessage("valuePresent"));
            log.error((Object)Messages.getMessage("valuePresent"), (Throwable)exc);
            throw exc;
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(el);
        el.parent = this;
    }

    public void removeChild(MessageElement child) {
        int i;
        while ((i = this.children.indexOf(child)) != -1) {
            this.children.remove(i);
        }
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public void setContentsIndex(int index) {
        this.startContentsIndex = index;
    }

    public void setNSMappings(ArrayList namespaces) {
        this.namespaces = namespaces;
    }

    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null || namespaceURI.equals("")) {
            return null;
        }
        if (this.href != null && this.getRealElement() != null) {
            return this.getRealElement().getPrefix(namespaceURI);
        }
        for (int i = 0; this.namespaces != null && i < this.namespaces.size(); ++i) {
            Mapping map = (Mapping)this.namespaces.get(i);
            if (!map.getNamespaceURI().equals(namespaceURI)) continue;
            return map.getPrefix();
        }
        if (this.parent != null) {
            return this.parent.getPrefix(namespaceURI);
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (this.href != null && this.getRealElement() != null) {
            return this.getRealElement().getNamespaceURI(prefix);
        }
        for (int i = 0; this.namespaces != null && i < this.namespaces.size(); ++i) {
            Mapping map = (Mapping)this.namespaces.get(i);
            if (!map.getPrefix().equals(prefix)) continue;
            return map.getNamespaceURI();
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("noPrefix00", "" + this, prefix));
        }
        return null;
    }

    public Object getObjectValue() {
        Object obj = null;
        try {
            obj = this.getObjectValue(null);
        }
        catch (Exception e) {
            log.debug((Object)"getValue()", (Throwable)e);
        }
        return obj;
    }

    public Object getObjectValue(Class cls) throws Exception {
        if (this.objectValue == null) {
            this.objectValue = this.getValueAsType(this.getType(), cls);
        }
        return this.objectValue;
    }

    public void setObjectValue(Object newValue) throws SOAPException {
        if (this.children != null && !this.children.isEmpty()) {
            SOAPException exc = new SOAPException(Messages.getMessage("childPresent"));
            log.error((Object)Messages.getMessage("childPresent"), (Throwable)exc);
            throw exc;
        }
        if (this.elementRep != null) {
            SOAPException exc = new SOAPException(Messages.getMessage("xmlPresent"));
            log.error((Object)Messages.getMessage("xmlPresent"), (Throwable)exc);
            throw exc;
        }
        if (this.textRep != null) {
            SOAPException exc = new SOAPException(Messages.getMessage("xmlPresent"));
            log.error((Object)Messages.getMessage("xmlPresent"), (Throwable)exc);
            throw exc;
        }
        this.objectValue = newValue;
    }

    public Object getValueAsType(QName type) throws Exception {
        return this.getValueAsType(type, null);
    }

    public Object getValueAsType(QName type, Class cls) throws Exception {
        if (this.context == null) {
            throw new Exception(Messages.getMessage("noContext00"));
        }
        Deserializer dser = null;
        dser = cls == null ? this.context.getDeserializerForType(type) : this.context.getDeserializerForClass(cls);
        if (dser == null) {
            throw new Exception(Messages.getMessage("noDeser00", "" + type));
        }
        boolean oldVal = this.context.isDoneParsing();
        ((DeserializationContextImpl)this.context).deserializing(true);
        this.context.pushElementHandler(new EnvelopeHandler((SOAPHandler)((Object)dser)));
        this.publishToHandler((ContentHandler)((Object)this.context));
        ((DeserializationContextImpl)this.context).deserializing(oldVal);
        return dser.getValue();
    }

    public void addAttribute(String namespace, String localName, QName value) {
        if (this.qNameAttrs == null) {
            this.qNameAttrs = new Vector();
        }
        QNameAttr attr = new QNameAttr();
        attr.name = new QName(namespace, localName);
        attr.value = value;
        this.qNameAttrs.addElement(attr);
    }

    protected AttributesImpl makeAttributesEditable() {
        if (this.attributes == null || this.attributes instanceof NullAttributes) {
            this.attributes = new AttributesImpl();
        } else if (!(this.attributes instanceof AttributesImpl)) {
            this.attributes = new AttributesImpl(this.attributes);
        }
        return (AttributesImpl)this.attributes;
    }

    public void addAttribute(String namespace, String localName, String value) {
        AttributesImpl attributes = this.makeAttributesEditable();
        attributes.addAttribute(namespace, localName, "", "CDATA", value);
    }

    public void addAttribute(String prefix, String namespace, String localName, String value) {
        AttributesImpl attributes = this.makeAttributesEditable();
        String attrName = localName;
        if (prefix != null && prefix.length() > 0) {
            attrName = prefix + ":" + localName;
        }
        attributes.addAttribute(namespace, localName, attrName, "CDATA", value);
    }

    public void setAttribute(String namespace, String localName, String value) {
        AttributesImpl attributes = this.makeAttributesEditable();
        int idx = attributes.getIndex(namespace, localName);
        if (idx > -1) {
            if (value != null) {
                attributes.setValue(idx, value);
            } else {
                attributes.removeAttribute(idx);
            }
            return;
        }
        this.addAttribute(namespace, localName, value);
    }

    public String getAttributeValue(String localName) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getValue(localName);
    }

    public void setEnvelope(SOAPEnvelope env) {
        env.setDirty(true);
        this.message = env;
    }

    public SOAPEnvelope getEnvelope() {
        return this.message;
    }

    public MessageElement getRealElement() {
        if (this.href == null) {
            return this;
        }
        Object obj = this.context.getObjectByRef(this.href);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof MessageElement)) {
            return null;
        }
        return (MessageElement)obj;
    }

    public Document getAsDocument() throws Exception {
        String elementString = this.getAsString();
        StringReader reader = new StringReader(elementString);
        Document doc = XMLUtils.newDocument(new InputSource(reader));
        if (doc == null) {
            throw new Exception(Messages.getMessage("noDoc00", elementString));
        }
        return doc;
    }

    public String getAsString() throws Exception {
        SerializationContextImpl serializeContext = null;
        StringWriter writer = new StringWriter();
        MessageContext msgContext = this.context != null ? this.context.getMessageContext() : MessageContext.getCurrentContext();
        serializeContext = new SerializationContextImpl(writer, msgContext);
        serializeContext.setSendDecl(false);
        this.output(serializeContext);
        writer.close();
        return writer.getBuffer().toString();
    }

    public Element getAsDOM() throws Exception {
        return this.getAsDocument().getDocumentElement();
    }

    public void publishToHandler(ContentHandler handler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(Messages.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startEventIndex, this.endEventIndex, handler);
    }

    public void publishContents(ContentHandler handler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(Messages.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startContentsIndex, this.endEventIndex - 1, handler);
    }

    public final void output(SerializationContext context) throws Exception {
        if (this.recorder != null && !this._isDirty) {
            this.recorder.replay(this.startEventIndex, this.endEventIndex, new SAXOutputter(context));
            return;
        }
        if (this.qNameAttrs != null) {
            for (int i = 0; i < this.qNameAttrs.size(); ++i) {
                QNameAttr attr = (QNameAttr)this.qNameAttrs.get(i);
                QName attrName = attr.name;
                this.setAttribute(attrName.getNamespaceURI(), attrName.getLocalPart(), context.qName2String(attr.value));
            }
        }
        if (this.encodingStyle != null) {
            SOAPConstants soapConstants;
            MessageContext mc = context.getMessageContext();
            SOAPConstants sOAPConstants = soapConstants = mc != null ? mc.getSOAPConstants() : SOAPConstants.SOAP11_CONSTANTS;
            if (this.parent == null) {
                if (!this.encodingStyle.equals("")) {
                    this.setAttribute(soapConstants.getEnvelopeURI(), "encodingStyle", this.encodingStyle);
                }
            } else if (!this.encodingStyle.equals(this.parent.getEncodingStyle())) {
                this.setAttribute(soapConstants.getEnvelopeURI(), "encodingStyle", this.encodingStyle);
            }
        }
        this.outputImpl(context);
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        if (this.elementRep != null) {
            boolean oldPretty = context.getPretty();
            context.setPretty(false);
            context.writeDOMElement(this.elementRep);
            context.setPretty(oldPretty);
            return;
        }
        if (this.textRep != null) {
            boolean oldPretty = context.getPretty();
            context.setPretty(false);
            context.writeSafeString(this.textRep.getData());
            context.setPretty(oldPretty);
            return;
        }
        if (this.prefix != null) {
            context.registerPrefixForURI(this.prefix, this.namespaceURI);
        }
        if (this.namespaces != null) {
            Iterator i = this.namespaces.iterator();
            while (i.hasNext()) {
                Mapping mapping = (Mapping)i.next();
                context.registerPrefixForURI(mapping.getPrefix(), mapping.getNamespaceURI());
            }
        }
        if (this.objectValue != null) {
            context.serialize(new QName(this.namespaceURI, this.name), this.attributes, this.objectValue, null, false, null);
            return;
        }
        context.startElement(new QName(this.namespaceURI, this.name), this.attributes);
        if (this.children != null) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                ((MessageElement)it.next()).output(context);
            }
        }
        context.endElement();
    }

    public String toString() {
        try {
            return this.getAsString();
        }
        catch (Exception exp) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exp);
            return null;
        }
    }

    public void addMapping(Mapping map) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        this.namespaces.add(map);
    }

    public String getValue() {
        try {
            Node node;
            Element element = this.getAsDOM();
            if (element.hasChildNodes() && (node = element.getFirstChild()).getNodeType() == 3) {
                return node.getNodeValue();
            }
        }
        catch (Exception t) {
            log.debug((Object)"getValue()", (Throwable)t);
        }
        return null;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            this.setParent((MessageElement)parent);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public SOAPElement getParentElement() {
        return this.getParent();
    }

    public void detachNode() {
        if (this.parent != null) {
            this.parent.removeChild(this);
            this.parent = null;
        }
    }

    public void recycleNode() {
    }

    public void setValue(String value) {
        if (this instanceof Text) {
            this.setNodeValue(value);
            return;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                MessageElement child = (MessageElement)this.children.get(i);
                if (!(child instanceof Text)) continue;
                child.setValue(value);
                return;
            }
        }
        throw new IllegalStateException("Cannot call set for Non Text Node");
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        MessageElement child = new MessageElement(name.getLocalName(), name.getPrefix(), name.getURI());
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        MessageElement child = new MessageElement(this.getNamespaceURI(), localName);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        MessageElement child = new MessageElement(this.getNamespaceURI(prefix), localName);
        child.setPrefix(prefix);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        MessageElement child = new MessageElement(uri, localName);
        child.setPrefix(prefix);
        child.addNamespaceDeclaration(prefix, uri);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        try {
            this.addChild((MessageElement)element);
            return element;
        }
        catch (ClassCastException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public SOAPElement addTextNode(String s) throws SOAPException {
        Text text = new Text(s);
        try {
            this.addChild(text);
            return this;
        }
        catch (ClassCastException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        try {
            this.addAttribute(name.getPrefix(), name.getURI(), name.getLocalName(), value);
        }
        catch (RuntimeException t) {
            throw new SOAPException((Throwable)t);
        }
        return this;
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        try {
            Mapping map = new Mapping(uri, prefix);
            this.addMapping(map);
        }
        catch (RuntimeException t) {
            throw new SOAPException((Throwable)t);
        }
        return this;
    }

    public String getAttributeValue(Name name) {
        return this.attributes.getValue(name.getURI(), name.getLocalName());
    }

    public Iterator getAllAttributes() {
        int num = this.attributes.getLength();
        Vector<PrefixedQName> attrs = new Vector<PrefixedQName>(num);
        for (int i = 0; i < num; ++i) {
            String q = this.attributes.getQName(i);
            String prefix = "";
            if (q != null) {
                int idx = q.indexOf(":");
                prefix = idx > 0 ? q.substring(0, idx) : "";
            }
            attrs.add(new PrefixedQName(this.attributes.getURI(i), this.attributes.getLocalName(i), prefix));
        }
        return attrs.iterator();
    }

    public Iterator getNamespacePrefixes() {
        Vector<String> prefixes = new Vector<String>();
        for (int i = 0; this.namespaces != null && i < this.namespaces.size(); ++i) {
            prefixes.add(((Mapping)this.namespaces.get(i)).getPrefix());
        }
        return prefixes.iterator();
    }

    public Name getElementName() {
        return new PrefixedQName(this.getNamespaceURI(), this.getName(), this.getPrefix());
    }

    public boolean removeAttribute(Name name) {
        AttributesImpl attributes = this.makeAttributesEditable();
        boolean removed = false;
        for (int i = 0; i < attributes.getLength() && !removed; ++i) {
            if (!attributes.getURI(i).equals(name.getURI()) || !attributes.getLocalName(i).equals(name.getLocalName())) continue;
            attributes.removeAttribute(i);
            removed = true;
        }
        return removed;
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        this.makeAttributesEditable();
        boolean removed = false;
        for (int i = 0; this.namespaces != null && i < this.namespaces.size() && !removed; ++i) {
            if (!((Mapping)this.namespaces.get(i)).getPrefix().equals(prefix)) continue;
            this.namespaces.remove(i);
            removed = true;
        }
        return removed;
    }

    public Iterator getChildElements() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children.iterator();
    }

    public Iterator getChildElements(Name name) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        int num = this.children.size();
        Vector<MessageElement> c = new Vector<MessageElement>(num);
        for (int i = 0; i < num; ++i) {
            MessageElement child = (MessageElement)this.children.get(i);
            Name cname = child.getElementName();
            if (!cname.getURI().equals(name.getURI()) || !cname.getLocalName().equals(name.getLocalName())) continue;
            c.add(child);
        }
        return c.iterator();
    }

    public String getTagName() {
        return this.prefix == null ? this.name : this.prefix + ":" + this.name;
    }

    public void removeAttribute(String name) throws DOMException {
        AttributesImpl impl = (AttributesImpl)this.attributes;
        int index = impl.getIndex(name);
        if (index >= 0) {
            AttributesImpl newAttrs = new AttributesImpl();
            for (int i = 0; i < impl.getLength(); ++i) {
                if (i == index) continue;
                String uri = impl.getURI(i);
                String local = impl.getLocalName(i);
                String qname = impl.getQName(i);
                String type = impl.getType(i);
                String value = impl.getValue(i);
                newAttrs.addAttribute(uri, local, qname, type, value);
            }
            this.attributes = newAttrs;
        }
    }

    public boolean hasAttribute(String name) {
        if (name == null) {
            name = "";
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            if (!name.equals(this.attributes.getQName(i))) continue;
            return true;
        }
        return false;
    }

    public String getAttribute(String name) {
        return this.attributes.getValue(name);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.makeAttributesEditable();
        PrefixedQName name = new PrefixedQName(namespaceURI, localName, null);
        this.removeAttribute(name);
    }

    public void setAttribute(String name, String value) throws DOMException {
        AttributesImpl impl = this.makeAttributesEditable();
        int index = impl.getIndex(name);
        if (index < 0) {
            String uri = "";
            String localname = name;
            String qname = name;
            String type = "CDDATA";
            impl.addAttribute(uri, localname, qname, type, value);
        } else {
            impl.setLocalName(index, value);
        }
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (localName == null) {
            localName = "";
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            if (!namespaceURI.equals(this.attributes.getURI(i)) || !localName.equals(this.attributes.getLocalName(i))) continue;
            return true;
        }
        return false;
    }

    public Attr getAttributeNode(String name) {
        return null;
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        this.makeAttributesEditable();
        PrefixedQName name = new PrefixedQName(oldAttr.getNamespaceURI(), oldAttr.getLocalName(), oldAttr.getPrefix());
        this.removeAttribute(name);
        return oldAttr;
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return newAttr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        AttributesImpl attributes = this.makeAttributesEditable();
        attributes.addAttribute(newAttr.getNamespaceURI(), newAttr.getLocalName(), newAttr.getLocalName(), "CDATA", newAttr.getValue());
        return null;
    }

    public NodeList getElementsByTagName(String name) {
        MessageElement nodelist = new MessageElement();
        try {
            if (this.children != null) {
                int i;
                for (i = 0; i < this.children.size(); ++i) {
                    nodelist.addChild((MessageElement)this.children.get(i));
                }
                for (i = 0; i < this.children.size(); ++i) {
                    MessageElement child = (MessageElement)this.children.get(i);
                    NodeList grandsons = child.getElementsByTagName(name);
                    for (int j = 0; j < this.children.size(); ++j) {
                        nodelist.addChild((MessageElement)((Object)grandsons.item(j)));
                    }
                }
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return nodelist;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            if (!this.attributes.getURI(i).equals(namespaceURI) || !this.attributes.getLocalName(i).equals(localName)) continue;
            return this.attributes.getValue(i);
        }
        return null;
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        AttributesImpl attributes = this.makeAttributesEditable();
        String localName = qualifiedName.substring(qualifiedName.indexOf(":") + 1, qualifiedName.length());
        if (namespaceURI == null) {
            namespaceURI = "intentionalNullURI";
        }
        attributes.addAttribute(namespaceURI, localName, qualifiedName, "CDATA", value);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return null;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsNS((Element)((Object)this), namespaceURI, localName);
    }

    protected NodeList getElementsNS(Element parent, String namespaceURI, String localName) {
        NodeList children = parent.getChildNodes();
        NodeListImpl matches = new NodeListImpl();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            if (child instanceof org.w3c.dom.Text) continue;
            if (namespaceURI.equals(child.getNamespaceURI()) && localName.equals(child.getLocalName())) {
                matches.addNode(child);
            }
            matches.addNodeList(child.getElementsByTagNameNS(namespaceURI, localName));
        }
        return matches;
    }

    public void setOwnerDocument(SOAPPart sp) {
        this.soapPart = sp;
    }

    public Node item(int index) {
        if (this.children != null && this.children.size() > index) {
            return (Node)this.children.get(index);
        }
        return null;
    }

    public int getLength() {
        if (this.children == null) {
            this.children = new ArrayList();
            return 0;
        }
        return this.children.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class QNameAttr {
        QName name;
        QName value;

        protected QNameAttr() {
        }
    }
}

