package org.seasar.axis.client;

import java.lang.reflect.Method;
import java.net.URL;

import javax.xml.namespace.QName;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.MethodUtil;

public class DynamicInvocationInterceptor extends AbstractInterceptor {
    final private Service service;
    final private URL url;

    public DynamicInvocationInterceptor(final Service service, final URL url) {
        this.service = service;
        this.url = url;
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        final Method method = invocation.getMethod();
		if (!MethodUtil.isAbstract(method)) {
			return invocation.proceed();
		}

		final Call call = (Call) service.createCall();
        call.setTargetEndpointAddress(url);
        call.setOperationName(new QName("http://soapinterop.org/", method
                .getName()));
        call.setReturnClass(method.getReturnType());
        return call.invoke(invocation.getArguments());
    }
}