/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.axis.server;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.seasar.axis.server.S2Provider;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class S2Handler
extends BasicHandler {
    private static final Log logger = LogFactory.getLog((String)(class$org$seasar$axis$server$S2Handler == null ? (class$org$seasar$axis$server$S2Handler = S2Handler.class$("org.seasar.axis.server.S2Handler")) : class$org$seasar$axis$server$S2Handler).getName());
    private final Map soapServices = new HashMap();
    static /* synthetic */ Class class$org$seasar$axis$server$S2Handler;

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            this.setupService(msgContext);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
    }

    protected void setupService(MessageContext msgContext) throws Exception {
        String componentName = this.getComponentName(msgContext);
        if (componentName == null) {
            return;
        }
        S2Container container = SingletonS2ContainerFactory.getContainer();
        if (!container.hasComponentDef((Object)componentName)) {
            return;
        }
        msgContext.setService(this.getService(msgContext, container, componentName));
    }

    protected String getComponentName(MessageContext msgContext) {
        String pathInfo = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO);
        if (pathInfo == null || pathInfo.length() == 0) {
            return null;
        }
        return pathInfo.substring(1).replace('/', '.');
    }

    protected SOAPService getService(MessageContext msgContext, S2Container container, String componentName) throws AxisFault {
        ComponentDef componentDef = container.getComponentDef((Object)componentName);
        SOAPService soapService = (SOAPService)this.soapServices.get(componentDef);
        if (soapService == null) {
            soapService = this.createService(msgContext, componentDef);
            this.soapServices.put(componentDef, soapService);
        }
        soapService.setEngine(msgContext.getAxisEngine());
        soapService.init();
        return soapService;
    }

    protected SOAPService createService(MessageContext msgContext, ComponentDef componentDef) throws AxisFault {
        SOAPService soapService = new SOAPService((Handler)new S2Provider());
        String componentClassName = componentDef.getComponentClass().getName();
        soapService.setName(componentClassName);
        soapService.setOption("className", (Object)componentClassName);
        soapService.setOption("componentDef", (Object)componentDef);
        soapService.getInitializedServiceDesc(msgContext);
        return soapService;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

