package org.seasar.extension.openamf;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

import org.openamf.util.OpenAMFUtils;

import flashgateway.io.ASObject;

/**
 * AS2NXJavaBeans֕ϊRo[^NX
 * 
 * @author Hidetoshi Hosokawa
 */
public class AS2Converter implements ParameterConverter {

	/** _remoteClass擾邽߂̃L[ */
	private final String REMOTE_CLASS_KEY = "_remoteClass";

	/**
	 * FlasḧJavaBeans֕ϊ܂B
	 * 
	 * @param component  ĂяoR|[lg
	 * @param methodName Ăяo惁\bh
	 * @param parameters \bḧ
	 */
	public Object[] convertParameters(
		Object component,
		String methodName,
		Object[] parameters)
		throws Exception {

		if (parameters == null) {
			return null;
		}

		Method matchMethod = null;
		Method rowMatchMethod = null;
		Method[] methods = component.getClass().getMethods();

		/* ĂяoΏۂƂȂ郁\bȟ */
		for (int methodIndex = 0; methodIndex < methods.length; methodIndex++) {

			if (!methods[methodIndex].getName().equalsIgnoreCase(methodName)) {
				continue;
			}

			Class[] parameterTypes = methods[methodIndex].getParameterTypes();
			if (parameterTypes.length != parameters.length) {
				continue;
			}

			int classMatchCount = 0;
			for (int argIndex = 0; argIndex < parameterTypes.length; argIndex++) {

				String className = parameters[argIndex].getClass().getName();
				if (parameters[argIndex] instanceof ASObject) {
					className = this.setRemoteClassType(parameters[argIndex]);

				} else if (parameters[argIndex] instanceof List) {
					List list = (List) parameters[argIndex];
					for (int listIndex = 0;	 listIndex < list.size(); listIndex++) {
						this.setRemoteClassType(list.get(listIndex));
					}
				}

				if (parameterTypes[argIndex].getName().equals(className)) {
					classMatchCount++;
				}
			}

			/* ݈̐̂v\bh */
			rowMatchMethod = methods[methodIndex];

			/* ̐ƌ^Sv */
			if (classMatchCount == parameterTypes.length) {
				matchMethod = methods[methodIndex];
				break;
			}
		}

		/* Sṽ\bhꍇAアɈv\bh */
		if (matchMethod == null) {
			matchMethod = rowMatchMethod;
		}

		Class[] parameterTypes = matchMethod.getParameterTypes();
		for (int i = 0; i < parameterTypes.length; i++) {
			Object decodeParam =
				OpenAMFUtils.decodeParameter(parameters[i], parameterTypes[i]);
			parameters[i] = decodeParam;
		}
		return parameters;
	}


	/**
	 * ASObjecttypeݒ肵܂B
	 * 
	 * @param object IuWFNg
	 * @return _remoteClass̒l
	 */
	private String setRemoteClassType(Object object) {
		String remoteClass = null;
		if (object instanceof ASObject) {
			ASObject asObject = (ASObject) object;
			remoteClass = (String) asObject.get(REMOTE_CLASS_KEY);
			if (remoteClass == null) {
				asObject.setType(Map.class.getName());
			} else {
				asObject.setType(remoteClass);
			}
		}
		return remoteClass;
	}
}