/*
 * Decompiled with CFR 0.152.
 */
package org.openamf.io;

import com.carbonfive.flash.IdentityMap;
import flashgateway.io.ASObject;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openamf.AMFBody;
import org.openamf.AMFHeader;
import org.openamf.AMFMessage;
import org.openamf.config.OpenAMFConfig;
import org.openamf.recordset.ASRecordSet;
import org.openamf.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AMFSerializer {
    private static final Log log = LogFactory.getLog((Class)(class$org$openamf$io$AMFSerializer == null ? (class$org$openamf$io$AMFSerializer = AMFSerializer.class$("org.openamf.io.AMFSerializer")) : class$org$openamf$io$AMFSerializer));
    private static final int MILLS_PER_HOUR = 60000;
    private static final String NULL_MESSAGE = "null";
    protected DataOutputStream outputStream;
    private IdentityMap storedObjects = new IdentityMap();
    private int storedObjectCount = 0;
    static /* synthetic */ Class class$org$openamf$io$AMFSerializer;

    public AMFSerializer(DataOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void serializeMessage(AMFMessage message) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Serializing Message, for more info turn on debug level");
        }
        this.clearStoredObjects();
        this.outputStream.writeShort(message.getVersion());
        this.outputStream.writeShort(message.getHeaderCount());
        Iterator headers = message.getHeaders().iterator();
        while (headers.hasNext()) {
            AMFHeader header = (AMFHeader)headers.next();
            this.writeHeader(header);
        }
        this.outputStream.writeShort(message.getBodyCount());
        Iterator bodies = message.getBodies();
        while (bodies.hasNext()) {
            AMFBody body = (AMFBody)bodies.next();
            this.writeBody(body);
        }
    }

    protected void writeHeader(AMFHeader header) throws IOException {
        this.outputStream.writeUTF(header.getKey());
        this.outputStream.writeBoolean(header.isRequired());
        this.outputStream.writeInt(-1);
        this.writeData(header.getValue());
    }

    protected void writeBody(AMFBody body) throws IOException {
        if (body.getTarget() == null) {
            this.outputStream.writeUTF(NULL_MESSAGE);
        } else {
            this.outputStream.writeUTF(body.getTarget());
        }
        if (body.getResponse() == null) {
            this.outputStream.writeUTF(NULL_MESSAGE);
        } else {
            this.outputStream.writeUTF(body.getResponse());
        }
        this.outputStream.writeInt(-1);
        this.writeData(body.getValue());
    }

    protected void writeData(Object value) throws IOException {
        if (value == null) {
            this.outputStream.writeByte(5);
        } else if (value instanceof Number) {
            this.outputStream.writeByte(0);
            this.outputStream.writeDouble(((Number)value).doubleValue());
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof Character) {
            this.outputStream.writeByte(2);
            this.outputStream.writeUTF(value.toString());
        } else if (value instanceof Boolean) {
            this.outputStream.writeByte(1);
            this.outputStream.writeBoolean((Boolean)value);
        } else if (value instanceof Date) {
            this.outputStream.writeByte(11);
            this.outputStream.writeDouble(((Date)value).getTime());
            int offset = TimeZone.getDefault().getRawOffset();
            this.outputStream.writeShort(offset / 60000);
        } else {
            if (this.storedObjects.containsKey(value)) {
                this.writeStoredObject(value);
                return;
            }
            this.storeObject(value);
            if (value instanceof Object[]) {
                this.writeArray((Object[])value);
            } else if (value instanceof Iterator) {
                this.write((Iterator)value);
            } else if (value instanceof Collection) {
                this.write((Collection)value);
            } else if (value instanceof Map) {
                this.writeMap((Map)value);
            } else if (value instanceof ResultSet) {
                ASRecordSet asRecordSet = new ASRecordSet();
                asRecordSet.populate((ResultSet)value);
                this.writeData(asRecordSet);
            } else if (value instanceof Document) {
                this.write((Document)value);
            } else {
                this.writeObject(value);
            }
        }
    }

    protected void writeObject(Object object) throws IOException {
        String customClassName;
        if (log.isDebugEnabled()) {
            if (object == null) {
                log.debug((Object)"Writing object, object param == null");
            } else {
                log.debug((Object)("Writing object, class = " + object.getClass()));
            }
        }
        if ((customClassName = OpenAMFConfig.getInstance().getCustomClassName(object.getClass().getName())) == null) {
            this.outputStream.writeByte(3);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("customClassName : " + customClassName));
            }
            this.outputStream.writeByte(16);
            this.outputStream.writeUTF(customClassName);
        }
        try {
            PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors((Object)object);
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].getName().equals("class")) continue;
                String propertyName = properties[i].getName();
                Method readMethod = properties[i].getReadMethod();
                Object propertyValue = null;
                if (readMethod == null) {
                    log.error((Object)("unable to find readMethod for : " + propertyName + " writing null!"));
                } else {
                    log.debug((Object)("invoking readMethod " + readMethod));
                    propertyValue = readMethod.invoke(object, new Object[0]);
                }
                log.debug((Object)(propertyName + " = " + propertyValue));
                this.outputStream.writeUTF(propertyName);
                this.writeData(propertyValue);
            }
            this.outputStream.writeShort(0);
            this.outputStream.writeByte(9);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    protected void writeArray(Object[] array) throws IOException {
        this.outputStream.writeByte(10);
        this.outputStream.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeData(array[i]);
        }
    }

    protected void write(Iterator iterator) throws IOException {
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        this.write(list);
    }

    protected void write(Collection collection) throws IOException {
        this.outputStream.writeByte(10);
        this.outputStream.writeInt(collection.size());
        Iterator objects = collection.iterator();
        while (objects.hasNext()) {
            Object object = objects.next();
            this.writeData(object);
        }
    }

    protected void writeMap(Map map) throws IOException {
        if (map instanceof ASObject && ((ASObject)map).getType() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Writing Custom Class: " + ((ASObject)map).getType()));
            }
            this.outputStream.writeByte(16);
            this.outputStream.writeUTF(((ASObject)map).getType());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Writing Map");
            }
            this.outputStream.writeByte(3);
        }
        Iterator entrys = map.entrySet().iterator();
        while (entrys.hasNext()) {
            Map.Entry entry = entrys.next();
            log.debug((Object)(entry.getKey() + ": " + entry.getValue()));
            this.outputStream.writeUTF(entry.getKey().toString());
            this.writeData(entry.getValue());
        }
        this.outputStream.writeShort(0);
        this.outputStream.writeByte(9);
    }

    protected void write(Document document) throws IOException {
        this.outputStream.writeByte(15);
        Element docElement = document.getDocumentElement();
        String xmlData = XMLUtils.convertDOMToString(docElement);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing xmlData: \n" + xmlData));
        }
        ByteArrayOutputStream baOutputStream = new ByteArrayOutputStream();
        baOutputStream.write(xmlData.getBytes());
        this.outputStream.writeInt(baOutputStream.size());
        baOutputStream.writeTo(this.outputStream);
    }

    protected int writeString(String str) throws IOException {
        byte[] bytearr;
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen <= 65535) {
            this.outputStream.writeByte(2);
            bytearr = new byte[utflen + 2];
        } else {
            this.outputStream.writeByte(12);
            bytearr = new byte[utflen + 4];
            bytearr[count++] = (byte)(utflen >>> 24 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 16 & 0xFF);
        }
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.outputStream.write(bytearr);
        return utflen + 2;
    }

    private void writeStoredObject(Object obj) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing object reference for " + obj));
        }
        this.outputStream.write(7);
        this.outputStream.writeShort((Integer)this.storedObjects.get(obj));
    }

    private void storeObject(Object obj) {
        this.storedObjects.put(obj, (Object)new Integer(this.storedObjectCount++));
    }

    private void clearStoredObjects() {
        this.storedObjects = new IdentityMap();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

