/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.attrs.Dumpable;
import org.objectweb.asm.util.DumpCodeVisitor;
import org.objectweb.asm.util.PrintClassVisitor;

public class DumpClassVisitor
extends PrintClassVisitor {
    private static final int ACCESS_CLASS = 262144;
    private static final int ACCESS_FIELD = 524288;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Prints the ASM code to generate the given class.");
            System.err.println("Usage: DumpClassVisitor <fully qualified class name or class file name>");
            System.exit(-1);
        }
        ClassReader classReader = stringArray[0].endsWith(".class") ? new ClassReader((InputStream)new FileInputStream(stringArray[0])) : new ClassReader(stringArray[0]);
        classReader.accept((ClassVisitor)new DumpClassVisitor(new PrintWriter(System.out)), PrintClassVisitor.DEFAULT_ATTRIBUTES, true);
    }

    public DumpClassVisitor(PrintWriter printWriter) {
        super(printWriter);
    }

    public void visit(int n, String string, String string2, String[] stringArray, String string3) {
        this.text.add("import org.objectweb.asm.*;\n");
        this.text.add("import org.objectweb.asm.attrs.*;\n");
        this.text.add("import java.io.FileOutputStream;\n\n");
        this.text.add("public class Dump implements Constants {\n\n");
        this.text.add("public static void main (String[] args) throws Exception {\n\n");
        this.text.add("ClassWriter cw = new ClassWriter(false);\n");
        this.text.add("CodeVisitor cv;\n\n");
        this.buf.setLength(0);
        this.buf.append("cw.visit(");
        this.appendAccess(n | 0x40000);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append("new String[] {");
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.buf.append(n2 == 0 ? " " : ", ");
                DumpClassVisitor.appendConstant(this.buf, stringArray[n2]);
                ++n2;
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string3);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.buf.setLength(0);
        this.buf.append("cw.visitInnerClass(");
        DumpClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string3);
        this.buf.append(", ");
        this.appendAccess(n);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitField(int n, String string, String string2, Object object, Attribute attribute) {
        this.buf.setLength(0);
        if (attribute != null) {
            this.buf.append("// FIELD ATTRIBUTES\n");
            Attribute attribute2 = attribute;
            int n2 = 1;
            while (attribute2 != null) {
                if (attribute2 instanceof Dumpable) {
                    ((Dumpable)attribute2).dump(this.buf, "attrs" + n2, null);
                    if (n2 > 1) {
                        this.buf.append("attrs" + (n2 - 1) + " = attrs" + n2 + ";\n");
                    }
                } else {
                    this.buf.append("// WARNING! skipped non standard field attribute of type ");
                    this.buf.append(attribute2.type).append("\n");
                }
                ++n2;
                attribute2 = attribute2.next;
            }
        }
        this.buf.append("cw.visitField(");
        this.appendAccess(n | 0x80000);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, object);
        if (attribute == null) {
            this.buf.append(", null);\n\n");
        } else {
            this.buf.append(", attrs1);\n\n");
        }
        this.text.add(this.buf.toString());
    }

    public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append("{\n");
        if (attribute != null) {
            this.buf.append("// METHOD ATTRIBUTES\n");
            Attribute attribute2 = attribute;
            int n2 = 1;
            while (attribute2 != null) {
                if (attribute2 instanceof Dumpable) {
                    ((Dumpable)attribute2).dump(this.buf, "attrs" + n2, null);
                    if (n2 > 1) {
                        this.buf.append("attrs" + (n2 - 1) + " = attrs" + n2 + ";\n");
                    }
                } else {
                    this.buf.append("// WARNING! skipped non standard method attribute of type ");
                    this.buf.append(attribute2.type).append("\n");
                }
                ++n2;
                attribute2 = attribute2.next;
            }
        }
        this.buf.append("cv = cw.visitMethod(");
        this.appendAccess(n);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append("new String[] {");
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.buf.append(n3 == 0 ? " " : ", ");
                DumpClassVisitor.appendConstant(this.buf, stringArray[n3]);
                ++n3;
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        if (attribute == null) {
            this.buf.append(", null);\n");
        } else {
            this.buf.append(", attrs1);\n");
        }
        this.text.add(this.buf.toString());
        DumpCodeVisitor dumpCodeVisitor = new DumpCodeVisitor();
        this.text.add(dumpCodeVisitor.getText());
        this.text.add("}\n");
        return dumpCodeVisitor;
    }

    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        if (attribute instanceof Dumpable) {
            this.buf.append("{\n");
            this.buf.append("// CLASS ATRIBUTE\n");
            ((Dumpable)attribute).dump(this.buf, "attr", null);
            this.buf.append("cw.visitAttribute(attr);\n");
            this.buf.append("}\n");
        } else {
            this.buf.append("// WARNING! skipped a non standard class attribute of type \"");
            this.buf.append(attribute.type).append("\"\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitEnd() {
        this.text.add("cw.visitEnd();\n\n");
        this.text.add("FileOutputStream os = new FileOutputStream(\"Dumped.class\");\n");
        this.text.add("os.write(cw.toByteArray());\n");
        this.text.add("os.close();\n");
        this.text.add("}\n");
        this.text.add("}\n");
        super.visitEnd();
    }

    void appendAccess(int n) {
        boolean bl = true;
        if ((n & 1) != 0) {
            this.buf.append("ACC_PUBLIC");
            bl = false;
        }
        if ((n & 2) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_PRIVATE");
            bl = false;
        }
        if ((n & 4) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_PROTECTED");
            bl = false;
        }
        if ((n & 0x10) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_FINAL");
            bl = false;
        }
        if ((n & 8) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_STATIC");
            bl = false;
        }
        if ((n & 0x20) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            if ((n & 0x40000) != 0) {
                this.buf.append("ACC_SUPER");
            } else {
                this.buf.append("ACC_SYNCHRONIZED");
            }
            bl = false;
        }
        if ((n & 0x40) != 0 && (n & 0x80000) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_VOLATILE");
            bl = false;
        }
        if ((n & 0x40) != 0 && (n & 0x40000) == 0 && (n & 0x80000) == 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_BRIDGE");
            bl = false;
        }
        if ((n & 0x80) != 0 && (n & 0x40000) == 0 && (n & 0x80000) == 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_VARARGS");
            bl = false;
        }
        if ((n & 0x80) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_TRANSIENT");
            bl = false;
        }
        if ((n & 0x100) != 0 && (n & 0x40000) == 0 && (n & 0x80000) == 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_NATIVE");
            bl = false;
        }
        if ((n & 0x100) != 0 && ((n & 0x40000) != 0 || (n & 0x80000) != 0)) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ENUM");
            bl = false;
        }
        if ((n & 0x400) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ABSTRACT");
            bl = false;
        }
        if ((n & 0x200) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_INTERFACE");
            bl = false;
        }
        if ((n & 0x800) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_STRICT");
            bl = false;
        }
        if ((n & 0x10000) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_SYNTHETIC");
            bl = false;
        }
        if ((n & 0x20000) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_DEPRECATED");
            bl = false;
        }
        if (bl) {
            this.buf.append("0");
        }
    }

    static void appendConstant(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof String) {
            String string = (String)object;
            stringBuffer.append("\"");
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\n') {
                    stringBuffer.append("\\n");
                } else if (c == '\\') {
                    stringBuffer.append("\\\\");
                } else if (c == '\"') {
                    stringBuffer.append("\\\"");
                } else {
                    stringBuffer.append(c);
                }
                ++n;
            }
            stringBuffer.append("\"");
        } else if (object instanceof Integer) {
            stringBuffer.append("new Integer(").append(object).append(")");
        } else if (object instanceof Float) {
            stringBuffer.append("new Float(").append(object).append("F)");
        } else if (object instanceof Long) {
            stringBuffer.append("new Long(").append(object).append("L)");
        } else if (object instanceof Double) {
            stringBuffer.append("new Double(").append(object).append(")");
        }
    }
}

