/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.groovy;

import groovy.lang.GroovyShell;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.groovy.control.CompilationFailedException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.groovy.SeasarBuilderException;

public class S2ContainerGroovyFactory
implements S2ContainerBuilder {
    protected S2ContainerGroovyFactory() {
    }

    public static S2Container create(String path) throws SeasarBuilderException {
        return new S2ContainerGroovyFactory().build(path);
    }

    public S2Container build(String path) throws SeasarBuilderException {
        S2Container container = null;
        try {
            InputStream stream = ResourceUtil.getResourceAsStream((String)path);
            GroovyShell shell = new GroovyShell();
            container = (S2Container)shell.evaluate(stream, path);
            if (container == null) {
                throw new SeasarBuilderException("The return value is null or not returning.");
            }
            if (!(container instanceof S2Container)) {
                throw new SeasarBuilderException("The return value is not instance of S2Container");
            }
        }
        catch (CompilationFailedException e) {
            throw new SeasarBuilderException(e);
        }
        catch (IOException e) {
            throw new SeasarBuilderException(e);
        }
        catch (RuntimeException e) {
            throw new SeasarBuilderException(e);
        }
        catch (NoClassDefFoundError e) {
            throw new SeasarBuilderException(e);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S2Container build(String path, ClassLoader classLoader) throws SeasarBuilderException {
        S2Container container = null;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            container = this.build(path);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return container;
    }

    public S2Container include(S2Container parent, String path) {
        S2Container container = this.build(path);
        parent.include(container);
        return parent;
    }
}

