/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.MethodInvocationImpl;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.EmptyRuntimeException;

public final class AopProxy
implements MethodInterceptor {
    private static final int AOP_PROXY_INDEX = 0;
    private static final int EQUALS_INTERCEPTOR_INDEX = 1;
    private static final int NONE_INTERCEPTOR_INDEX = 2;
    private Class targetClass_;
    private Pointcut defaultPointcut_;
    private Aspect[] aspects_;
    private Map interceptorsMap_ = new HashMap();

    public AopProxy(Class targetClass, Aspect[] aspects) {
        if (targetClass == null) {
            throw new EmptyRuntimeException("targetClass");
        }
        this.setTargetClass(targetClass);
        this.setAspects(aspects);
    }

    private void setTargetClass(Class targetClass) {
        this.targetClass_ = targetClass;
        this.defaultPointcut_ = new PointcutImpl(targetClass);
    }

    private void setAspects(Aspect[] aspects) {
        if (aspects == null || aspects.length == 0) {
            throw new EmptyRuntimeException("aspects");
        }
        this.aspects_ = aspects;
        for (int i = 0; i < aspects.length; ++i) {
            Aspect aspect = aspects[i];
            if (aspect.getPointcut() != null) continue;
            aspect.setPointcut(this.defaultPointcut_);
        }
        String[] names = BeanDescFactory.getBeanDesc(this.targetClass_).getMethodNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            ArrayList<org.aopalliance.intercept.MethodInterceptor> interceptorList = new ArrayList<org.aopalliance.intercept.MethodInterceptor>();
            for (int j = 0; j < aspects.length; ++j) {
                Aspect aspect = aspects[j];
                if (!aspect.getPointcut().isApplied(name)) continue;
                interceptorList.add(aspect.getMethodInterceptor());
            }
            if (interceptorList.size() <= 0) continue;
            this.interceptorsMap_.put(name, interceptorList.toArray(new org.aopalliance.intercept.MethodInterceptor[interceptorList.size()]));
        }
    }

    public Object create() {
        Enhancer e = this.setupEnhancer();
        return e.create();
    }

    public Object create(Class[] argTypes, Object[] args) {
        Enhancer e = this.setupEnhancer();
        return e.create(argTypes, args);
    }

    private Enhancer setupEnhancer() {
        Enhancer e = new Enhancer();
        e.setSuperclass(this.targetClass_);
        e.setCallbacks(new Callback[]{this, new EqualsInterceptor(), NoOp.INSTANCE});
        e.setCallbackFilter((CallbackFilter)new MyCallbackFilter());
        return e;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        org.aopalliance.intercept.MethodInterceptor[] interceptors = (org.aopalliance.intercept.MethodInterceptor[])this.interceptorsMap_.get(method.getName());
        MethodInvocationImpl invocation = new MethodInvocationImpl(obj, method, args, proxy, interceptors, this.targetClass_);
        return invocation.proceed();
    }

    private class MyCallbackFilter
    implements CallbackFilter {
        MyCallbackFilter() {
        }

        public int accept(Method method) {
            if (AopProxy.this.interceptorsMap_.containsKey(method.getName())) {
                return 0;
            }
            if (this.isEqualsMethod(method)) {
                return 1;
            }
            return 2;
        }

        private boolean isEqualsMethod(Method method) {
            return "equals".equals(method.getName()) && method.getParameterTypes().length == 1 && method.getReturnType() == Boolean.TYPE;
        }
    }

    private class EqualsInterceptor
    implements MethodInterceptor {
        private EqualsInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (args[0] == obj) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

