/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.util.io.DataSqueezer;
import org.apache.tapestry.util.io.ISqueezeAdaptor;
import org.apache.tapestry.util.io.ResolvingObjectInputStream;

class SerializableAdaptor
implements ISqueezeAdaptor {
    private static final String PREFIX = "O";
    private static final char PAD = '.';
    private static final char CH_62 = '-';
    private static final char CH_63 = '_';
    static /* synthetic */ Class class$java$io$Serializable;

    SerializableAdaptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String squeeze(DataSqueezer squeezer, Object data) throws IOException {
        ByteArrayOutputStream bos = null;
        GZIPOutputStream gos = null;
        ObjectOutputStream oos = null;
        byte[] byteData = null;
        try {
            bos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(bos);
            oos = new ObjectOutputStream(gos);
            oos.writeObject(data);
            oos.close();
            Object var8_7 = null;
            this.close(oos);
            this.close(gos);
            this.close(bos);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.close(oos);
            this.close(gos);
            this.close(bos);
            throw throwable;
        }
        byteData = bos.toByteArray();
        StringBuffer encoded = new StringBuffer(2 * byteData.length);
        char[] base64 = new char[4];
        encoded.append(PREFIX);
        int i = 0;
        while (i < byteData.length) {
            SerializableAdaptor.encodeBlock(byteData, i, base64);
            encoded.append(base64);
            i += 3;
        }
        return encoded.toString();
    }

    private void close(OutputStream stream) {
        block2: {
            if (stream == null) break block2;
            try {
                stream.close();
            }
            catch (IOException ex) {}
        }
    }

    private void close(InputStream stream) {
        block2: {
            if (stream == null) break block2;
            try {
                stream.close();
            }
            catch (IOException ex) {}
        }
    }

    public Object unsqueeze(DataSqueezer squeezer, String string) throws IOException {
        ByteArrayInputStream bis = null;
        GZIPInputStream gis = null;
        ResolvingObjectInputStream ois = null;
        byte[] byteData = SerializableAdaptor.decode(string.substring(1));
        try {
            bis = new ByteArrayInputStream(byteData);
            gis = new GZIPInputStream(bis);
            ois = new ResolvingObjectInputStream(squeezer.getResolver(), gis);
            Object object = ois.readObject();
            Object var9_9 = null;
            this.close(ois);
            this.close(gis);
            this.close(bis);
            return object;
        }
        catch (ClassNotFoundException ex) {
            try {
                throw new IOException(Tapestry.format("SerializableAdaptor.class-not-found", ex.getMessage()));
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.close(ois);
                this.close(gis);
                this.close(bis);
                throw throwable;
            }
        }
    }

    public void register(DataSqueezer squeezer) {
        squeezer.register(PREFIX, class$java$io$Serializable == null ? (class$java$io$Serializable = SerializableAdaptor.class$("java.io.Serializable")) : class$java$io$Serializable, this);
    }

    private static void encodeBlock(byte[] raw, int offset, char[] base64) throws IOException {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        int i = 0;
        while (i <= end) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            int sixbit = block >>> 6 * (3 - i2) & 0x3F;
            base64[i2] = SerializableAdaptor.getChar(sixbit);
            ++i2;
        }
        if (slack < 1) {
            base64[2] = 46;
        }
        if (slack < 2) {
            base64[3] = 46;
        }
    }

    protected static char getChar(int sixBit) throws IOException {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '-';
        }
        if (sixBit == 63) {
            return '_';
        }
        throw new IOException(Tapestry.format("SerializableAdaptor.unable-to-convert", Integer.toString(sixBit)));
    }

    public static byte[] decode(String string) throws IOException {
        int pad = 0;
        char[] base64 = string.toCharArray();
        int i = base64.length - 1;
        while (base64[i] == '.') {
            ++pad;
            --i;
        }
        int length = base64.length * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawIndex = 0;
        int i2 = 0;
        while (i2 < base64.length) {
            int block = (SerializableAdaptor.getValue(base64[i2]) << 18) + (SerializableAdaptor.getValue(base64[i2 + 1]) << 12) + (SerializableAdaptor.getValue(base64[i2 + 2]) << 6) + SerializableAdaptor.getValue(base64[i2 + 3]);
            int j = 0;
            while (j < 3 && rawIndex + j < raw.length) {
                raw[rawIndex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
                ++j;
            }
            rawIndex += 3;
            i2 += 4;
        }
        return raw;
    }

    private static int getValue(char c) throws IOException {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '-') {
            return 62;
        }
        if (c == '_') {
            return 63;
        }
        if (c == '.') {
            return 0;
        }
        throw new IOException(Tapestry.format("SerializableAdaptor.unable-to-interpret-char", new String(new char[]{c})));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

