/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.resource;

import java.net.URL;
import java.util.Locale;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.resource.AbstractResourceLocation;
import org.apache.tapestry.util.LocalizedResource;
import org.apache.tapestry.util.LocalizedResourceFinder;

public class ClasspathResourceLocation
extends AbstractResourceLocation {
    private IResourceResolver _resolver;

    public ClasspathResourceLocation(IResourceResolver resolver, String path) {
        this(resolver, path, null);
    }

    public ClasspathResourceLocation(IResourceResolver resolver, String path, Locale locale) {
        super(path, locale);
        this._resolver = resolver;
    }

    public IResourceLocation getLocalization(Locale locale) {
        LocalizedResourceFinder finder = new LocalizedResourceFinder(this._resolver);
        String path = this.getPath();
        LocalizedResource localizedResource = finder.resolve(path, locale);
        if (localizedResource == null) {
            return null;
        }
        String localizedPath = localizedResource.getResourcePath();
        Locale pathLocale = localizedResource.getResourceLocale();
        if (localizedPath == null) {
            return null;
        }
        if (path.equals(localizedPath)) {
            return this;
        }
        return new ClasspathResourceLocation(this._resolver, localizedPath, pathLocale);
    }

    public URL getResourceURL() {
        return this._resolver.getResource(this.getPath());
    }

    public String toString() {
        return "classpath:" + this.getPath();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(4783, 23);
        builder.append((Object)this.getPath());
        return builder.toHashCode();
    }

    protected IResourceLocation buildNewResourceLocation(String path) {
        return new ClasspathResourceLocation(this._resolver, path);
    }
}

