/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.resolver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.resolver.AbstractSpecificationResolver;
import org.apache.tapestry.spec.IComponentSpecification;

public class ComponentSpecificationResolver
extends AbstractSpecificationResolver {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$resolver$ComponentSpecificationResolver == null ? (class$org$apache$tapestry$resolver$ComponentSpecificationResolver = ComponentSpecificationResolver.class$("org.apache.tapestry.resolver.ComponentSpecificationResolver")) : class$org$apache$tapestry$resolver$ComponentSpecificationResolver));
    private String _type;
    static /* synthetic */ Class class$org$apache$tapestry$resolver$ComponentSpecificationResolver;

    public ComponentSpecificationResolver(IRequestCycle cycle) {
        super(cycle);
    }

    protected void reset() {
        this._type = null;
        super.reset();
    }

    public void resolve(IRequestCycle cycle, INamespace containerNamespace, String type, ILocation location) {
        int colonx = type.indexOf(58);
        if (colonx > 0) {
            String libraryId = type.substring(0, colonx);
            String simpleType = type.substring(colonx + 1);
            this.resolve(cycle, containerNamespace, libraryId, simpleType, location);
        } else {
            this.resolve(cycle, containerNamespace, null, type, location);
        }
    }

    public void resolve(IRequestCycle cycle, INamespace containerNamespace, String libraryId, String type, ILocation location) {
        this.reset();
        this._type = type;
        INamespace namespace = null;
        namespace = libraryId != null ? containerNamespace.getChildNamespace(libraryId) : containerNamespace;
        this.setNamespace(namespace);
        if (namespace.containsComponentType(type)) {
            this.setSpecification(namespace.getComponentSpecification(type));
        } else {
            this.searchForComponent(cycle);
        }
        if (this.getSpecification() == null) {
            throw new ApplicationRuntimeException(Tapestry.format("Namespace.no-such-component-type", type, namespace.getNamespaceId()), location, null);
        }
    }

    private void searchForComponent(IRequestCycle cycle) {
        INamespace framework;
        INamespace namespace = this.getNamespace();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolving unknown component '" + this._type + "' in " + namespace));
        }
        String expectedName = this._type + ".jwc";
        IResourceLocation namespaceLocation = namespace.getSpecificationLocation();
        if (this.found(namespaceLocation.getRelativeLocation(expectedName))) {
            return;
        }
        if (namespace.isApplicationNamespace()) {
            if (this.found(this.getWebInfAppLocation().getRelativeLocation(expectedName))) {
                return;
            }
            if (this.found(this.getWebInfLocation().getRelativeLocation(expectedName))) {
                return;
            }
            if (this.found(this.getApplicationRootLocation().getRelativeLocation(expectedName))) {
                return;
            }
        }
        if ((framework = this.getSpecificationSource().getFrameworkNamespace()).containsComponentType(this._type)) {
            this.setSpecification(framework.getComponentSpecification(this._type));
            return;
        }
        IComponentSpecification specification = this.getDelegate().findComponentSpecification(cycle, namespace, this._type);
        this.setSpecification(specification);
    }

    private boolean found(IResourceLocation location) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking: " + location));
        }
        if (location.getResourceURL() == null) {
            return false;
        }
        this.setSpecification(this.getSpecificationSource().getComponentSpecification(location));
        this.install();
        return true;
    }

    private void install() {
        INamespace namespace = this.getNamespace();
        IComponentSpecification specification = this.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Installing component type " + this._type + " into " + namespace + " as " + specification));
        }
        namespace.installComponentSpecification(this._type, specification);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

