/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.util.HashSet;
import java.util.Set;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.request.RequestContext;

public abstract class Select
extends AbstractFormComponent {
    private boolean _rewinding;
    private boolean _rendering;
    private Set _selections;
    private int _nextOptionId;
    private static final String ATTRIBUTE_NAME = "org.apache.tapestry.active.Select";

    public static Select get(IRequestCycle cycle) {
        return (Select)cycle.getAttribute(ATTRIBUTE_NAME);
    }

    public abstract boolean isDisabled();

    public abstract boolean isMultiple();

    public boolean isRewinding() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "rewinding");
        }
        return this._rewinding;
    }

    public String getNextOptionId() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "nextOptionId");
        }
        return Integer.toString(this._nextOptionId++);
    }

    public boolean isSelected(String value) {
        if (this._selections == null) {
            return false;
        }
        return this._selections.contains(value);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = this.getForm(cycle);
        if (cycle.getAttribute(ATTRIBUTE_NAME) != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("Select.may-not-nest"), this, null, null);
        }
        this._rewinding = form.isRewinding();
        String name = form.getElementId(this);
        cycle.setAttribute(ATTRIBUTE_NAME, this);
        if (this._rewinding) {
            this._selections = this.buildSelections(cycle, name);
        } else {
            writer.begin("select");
            writer.attribute("name", name);
            if (this.isMultiple()) {
                writer.attribute("multiple", "multiple");
            }
            if (this.isDisabled()) {
                writer.attribute("disabled", "disabled");
            }
            this.renderInformalParameters(writer, cycle);
        }
        this._rendering = true;
        this._nextOptionId = 0;
        this.renderBody(writer, cycle);
        if (!this._rewinding) {
            writer.end();
        }
        cycle.removeAttribute(ATTRIBUTE_NAME);
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._rendering = false;
        this._selections = null;
        super.cleanupAfterRender(cycle);
    }

    private Set buildSelections(IRequestCycle cycle, String parameterName) {
        RequestContext context = cycle.getRequestContext();
        String[] parameters = context.getParameters(parameterName);
        if (parameters == null) {
            return null;
        }
        int length = parameters.length;
        int size = parameters.length > 30 ? 101 : 7;
        HashSet<String> result = new HashSet<String>(size);
        int i = 0;
        while (i < length) {
            result.add(parameters[i]);
            ++i;
        }
        return result;
    }
}

