/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.io.IOException;
import java.util.Iterator;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.util.io.DataSqueezer;

public abstract class ListEdit
extends AbstractFormComponent {
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Iterator i = null;
        IForm form = this.getForm(cycle);
        boolean cycleRewinding = cycle.isRewinding();
        if (cycleRewinding && !form.isRewinding()) {
            return;
        }
        String name = form.getElementId(this);
        if (!cycleRewinding) {
            i = Tapestry.coerceToIterator(this.getSourceBinding().getObject());
        } else {
            RequestContext context = cycle.getRequestContext();
            String[] submittedValues = context.getParameters(name);
            i = Tapestry.coerceToIterator(submittedValues);
        }
        if (i == null) {
            return;
        }
        int index = 0;
        IBinding indexBinding = this.getIndexBinding();
        IBinding valueBinding = this.getValueBinding();
        IActionListener listener = this.getListener();
        String element = this.getElement();
        while (i.hasNext()) {
            Object value = null;
            if (indexBinding != null) {
                indexBinding.setInt(index++);
            }
            if (cycleRewinding) {
                value = this.convertValue((String)i.next());
            } else {
                value = i.next();
                this.writeValue(form, name, value);
            }
            valueBinding.setObject(value);
            if (listener != null) {
                listener.actionTriggered(this, cycle);
            }
            if (element != null) {
                writer.begin(element);
                this.renderInformalParameters(writer, cycle);
            }
            this.renderBody(writer, cycle);
            if (element == null) continue;
            writer.end();
        }
    }

    private void writeValue(IForm form, String name, Object value) {
        String externalValue;
        try {
            externalValue = this.getDataSqueezer().squeeze(value);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ListEdit.unable-to-convert-value", value), this, null, ex);
        }
        form.addHiddenValue(name, externalValue);
    }

    private Object convertValue(String value) {
        try {
            return this.getDataSqueezer().unsqueeze(value);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ListEdit.unable-to-convert-string", value), this, null, ex);
        }
    }

    public abstract String getElement();

    private DataSqueezer getDataSqueezer() {
        return this.getPage().getEngine().getDataSqueezer();
    }

    public abstract IActionListener getListener();

    public abstract IBinding getSourceBinding();

    public abstract IBinding getValueBinding();

    public abstract IBinding getIndexBinding();

    public boolean isDisabled() {
        return false;
    }
}

