/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.AbstractFormComponent;

public abstract class AbstractTextField
extends AbstractFormComponent {
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = this.getForm(cycle);
        boolean rewinding = form.isRewinding();
        if (!rewinding && cycle.isRewinding()) {
            return;
        }
        String name = form.getElementId(this);
        if (rewinding) {
            if (!this.isDisabled()) {
                String value = cycle.getRequestContext().getParameter(name);
                this.updateValue(value);
            }
            return;
        }
        writer.beginEmpty("input");
        writer.attribute("type", this.isHidden() ? "password" : "text");
        if (this.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        writer.attribute("name", name);
        String value = this.readValue();
        if (value != null) {
            writer.attribute("value", value);
        }
        this.renderInformalParameters(writer, cycle);
        this.beforeCloseTag(writer, cycle);
        writer.closeTag();
    }

    protected void beforeCloseTag(IMarkupWriter writer, IRequestCycle cycle) {
    }

    protected abstract void updateValue(String var1);

    protected abstract String readValue();

    public abstract boolean isHidden();

    public abstract boolean isDisabled();
}

