/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.request.RequestContext;

public class EngineServiceLink
implements ILink {
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final URLCodec _urlCodec = new URLCodec();
    private IRequestCycle _cycle;
    private String _service;
    private String[] _parameters;
    private boolean _stateful;

    public EngineServiceLink(IRequestCycle cycle, String serviceName, String[] serviceContext, String[] serviceParameters, boolean stateful) {
        this._cycle = cycle;
        this._service = this.constructServiceValue(serviceName, serviceContext);
        this._parameters = serviceParameters;
        this._stateful = stateful;
    }

    private String constructServiceValue(String serviceName, String[] serviceContext) {
        int count = Tapestry.size(serviceContext);
        if (count == 0) {
            return serviceName;
        }
        StringBuffer buffer = new StringBuffer(serviceName);
        int i = 0;
        while (i < count) {
            buffer.append('/');
            buffer.append(serviceContext[i]);
            ++i;
        }
        return buffer.toString();
    }

    public String getURL() {
        return this.getURL(null, true);
    }

    public String getURL(String anchor, boolean includeParameters) {
        return this.constructURL(new StringBuffer(), anchor, includeParameters);
    }

    public String getAbsoluteURL() {
        return this.getAbsoluteURL(null, null, 0, null, true);
    }

    public String getAbsoluteURL(String scheme, String server, int port, String anchor, boolean includeParameters) {
        StringBuffer buffer = new StringBuffer();
        RequestContext context = this._cycle.getRequestContext();
        if (scheme == null) {
            scheme = context.getScheme();
        }
        buffer.append(scheme);
        buffer.append("://");
        if (server == null) {
            server = context.getServerName();
        }
        buffer.append(server);
        if (port == 0) {
            port = context.getServerPort();
        }
        if (!scheme.equals("http") || port != 80) {
            buffer.append(':');
            buffer.append(port);
        }
        return this.constructURL(buffer, anchor, includeParameters);
    }

    private String constructURL(StringBuffer buffer, String anchor, boolean includeParameters) {
        buffer.append(this._cycle.getEngine().getServletPath());
        if (includeParameters) {
            buffer.append('?');
            buffer.append("service");
            buffer.append('=');
            buffer.append(this._service);
            int count = Tapestry.size(this._parameters);
            int i = 0;
            while (i < count) {
                buffer.append('&');
                buffer.append("sp");
                buffer.append('=');
                String encoding = this._cycle.getEngine().getOutputEncoding();
                try {
                    String encoded = _urlCodec.encode(this._parameters[i], encoding);
                    buffer.append(encoded);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ApplicationRuntimeException(Tapestry.format("illegal-encoding", encoding), e);
                }
                ++i;
            }
        }
        if (anchor != null) {
            buffer.append('#');
            buffer.append(anchor);
        }
        String result = buffer.toString();
        if (this._stateful) {
            result = this._cycle.encodeURL(result);
        }
        return result;
    }

    public String[] getParameterNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("service");
        if (Tapestry.size(this._parameters) != 0) {
            list.add("sp");
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getParameterValues(String name) {
        if (name.equals("service")) {
            return new String[]{this._service};
        }
        if (name.equals("sp")) {
            return this._parameters;
        }
        throw new IllegalArgumentException(Tapestry.format("EngineServiceLink.unknown-parameter-name", name));
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("service", (Object)this._service);
        builder.append("parameters", (Object[])this._parameters);
        builder.append("stateful", this._stateful);
        return builder.toString();
    }
}

