/*
 * 쐬F 2004/09/01
 */
package org.seasar.tapestry.pageinjection.impl;

import java.lang.reflect.Method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.tapestry.pageinjection.IInjection;

/**
 * gbvx̃IuWFNgɑ΂DIsB
 * 
 * @author maruo_syunsuke
 */
public class TopInjection implements IInjection {
	private S2Container container;

	private static final Log LOG = LogFactory.getLog(TopInjection.class);

	/**
	 * ReiDIs <br>
	 * targetƓIuWFNgԂĂ܂Aۏ͂܂B <br>
	 * 
	 * @param target
	 *            CWFNVIuWFNg
	 */
	public void injection(Object target) {
		S2Container container = this.getContainer().getRoot();

		Method[] methods = target.getClass().getDeclaredMethods();
		for (int i = 0; i < methods.length; i++) {
			Method method = methods[i];
			if (method.getName().matches("^set.*") == false)
				continue;

			Class clazz = method.getParameterTypes()[0];
			if (clazz.isPrimitive())
				continue;

			if (container.hasComponentDef(clazz) == false)
				continue;
			try {
				Object injectObject = container.getComponent(clazz);
				if (injectObject != null) {
					method.invoke(target, new Object[] { injectObject });
					LOG.info(injectObject.getClass().getName()
							+ " is Injectioned to "
							+ target.getClass().getName());
				}
			} catch (Exception e) {
				LOG.debug("", e);
			}
		}
	}

	public S2Container getContainer() {
		return this.container;
	}

	public void setContainer(S2Container container) {
		this.container = container;
	}
}