/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.util.Locale;
import org.apache.tapestry.engine.IPropertySource;
import org.apache.tapestry.util.DelegatingPropertySource;
import org.apache.tapestry.util.LocalizedNameGenerator;

public class LocalizedPropertySource
extends DelegatingPropertySource {
    private Locale _locale;

    public LocalizedPropertySource() {
        this(Locale.getDefault());
    }

    public LocalizedPropertySource(Locale locale) {
        this.setLocale(locale);
    }

    public LocalizedPropertySource(IPropertySource delegate) {
        this(Locale.getDefault(), delegate);
    }

    public LocalizedPropertySource(Locale locale, IPropertySource delegate) {
        super(delegate);
        this.setLocale(locale);
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public String getPropertyValue(String propertyName) {
        LocalizedNameGenerator generator = new LocalizedNameGenerator(propertyName, this.getLocale(), "");
        while (generator.more()) {
            String candidateName = generator.next();
            String value = super.getPropertyValue(candidateName);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

