/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IScript;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.html.Body;

public abstract class Script
extends AbstractComponent {
    private Map _baseSymbols;
    private Map _symbols;

    private Map getInputSymbols() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this._baseSymbols != null) {
            result.putAll(this._baseSymbols);
        }
        Iterator i = this.getBindingNames().iterator();
        while (i.hasNext()) {
            String bindingName = (String)i.next();
            if (this.getSpecification().getParameter(bindingName) != null) continue;
            IBinding binding = this.getBinding(bindingName);
            Object value = binding.getObject();
            result.put(bindingName, value);
        }
        return result;
    }

    private IScript getParsedScript(IRequestCycle cycle) {
        String scriptPath = this.getScriptPath();
        if (scriptPath == null) {
            throw Tapestry.createRequiredParameterException(this, "scriptPath");
        }
        IEngine engine = cycle.getEngine();
        IScriptSource source = engine.getScriptSource();
        IResourceLocation rootLocation = this.getContainer().getSpecification().getSpecificationLocation();
        IResourceLocation scriptLocation = rootLocation.getRelativeLocation(scriptPath);
        try {
            return source.getScript(scriptLocation);
        }
        catch (RuntimeException ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), this, null, ex);
        }
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (!cycle.isRewinding()) {
            Body body = Body.get(cycle);
            if (body == null) {
                throw new ApplicationRuntimeException(Tapestry.getMessage("Script.must-be-contained-by-body"), this, null, null);
            }
            this._symbols = this.getInputSymbols();
            this.getParsedScript(cycle).execute(cycle, body, this._symbols);
        }
        this.renderBody(writer, cycle);
    }

    public abstract String getScriptPath();

    public Map getBaseSymbols() {
        return this._baseSymbols;
    }

    public void setBaseSymbols(Map baseSymbols) {
        this._baseSymbols = baseSymbols;
    }

    public Map getSymbols() {
        return this._symbols;
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._symbols = null;
        super.cleanupAfterRender(cycle);
    }
}

