/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IAction;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.StaleSessionException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.AbstractService;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.request.ResponseOutputStream;

public class ActionService
extends AbstractService {
    private static final String STATEFUL_ON = "1";
    private static final String STATEFUL_OFF = "0";

    public ILink getLink(IRequestCycle cycle, IComponent component, Object[] parameters) {
        if (parameters == null || parameters.length != 1) {
            throw new IllegalArgumentException(Tapestry.format("service-single-parameter", "action"));
        }
        String stateful = cycle.getEngine().isStateful() ? STATEFUL_ON : STATEFUL_OFF;
        IPage componentPage = component.getPage();
        IPage responsePage = cycle.getPage();
        boolean complex = componentPage != responsePage;
        String[] serviceContext = new String[complex ? 5 : 4];
        int i = 0;
        serviceContext[i++] = stateful;
        serviceContext[i++] = responsePage.getPageName();
        serviceContext[i++] = (String)parameters[0];
        if (complex) {
            serviceContext[i++] = componentPage.getPageName();
        }
        serviceContext[i++] = component.getIdPath();
        return this.constructLink(cycle, "action", serviceContext, null, true);
    }

    public void service(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output) throws ServletException, IOException {
        HttpSession session;
        IAction action = null;
        int count = 0;
        String[] serviceContext = this.getServiceContext(cycle.getRequestContext());
        if (serviceContext != null) {
            count = serviceContext.length;
        }
        if (count != 4 && count != 5) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("ActionService.context-parameters"));
        }
        boolean complex = count == 5;
        int i = 0;
        String stateful = serviceContext[i++];
        String pageName = serviceContext[i++];
        String targetActionId = serviceContext[i++];
        String componentPageName = complex ? serviceContext[i++] : pageName;
        String targetIdPath = serviceContext[i++];
        IPage page = cycle.getPage(pageName);
        cycle.activate(page);
        IPage componentPage = cycle.getPage(componentPageName);
        IComponent component = componentPage.getNestedComponent(targetIdPath);
        try {
            action = (IAction)component;
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ActionService.component-wrong-type", component.getExtendedId()), component, null, ex);
        }
        if (stateful.equals(STATEFUL_ON) && action.getRequiresSession() && ((session = cycle.getRequestContext().getSession()) == null || session.isNew())) {
            throw new StaleSessionException();
        }
        cycle.rewindPage(targetActionId, action);
        engine.renderResponse(cycle, output);
    }

    public String getName() {
        return "action";
    }
}

