package org.seasar.dao.impl;

import javax.sql.DataSource;

import org.seasar.dao.CommandContext;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.SelectHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;

/**
 * @author higa
 *  
 */
public class SelectDynamicCommand extends AbstractDynamicCommand {

	private ResultSetHandler resultSetHandler_;

	public SelectDynamicCommand(DataSource dataSource,
			ResultSetHandler resultSetHandler) {

		super(dataSource);
		resultSetHandler_ = resultSetHandler;
	}

	public ResultSetHandler getResultSetHandler() {
		return resultSetHandler_;
	}

	public Object execute(Object[] args) {
		CommandContext ctx = apply(args);
		SelectHandler selectHandler = new BasicSelectHandler(getDataSource(),
				ctx.getSql(), resultSetHandler_);
		return selectHandler.execute(ctx.getBindVariables());
	}
}