/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.impl.DaoMetaDataImpl;

public class DaoMetaDataFactory {
    private Map daoMetaDataCache_ = new HashMap();
    private DataSource dataSource_;

    public DaoMetaDataFactory(DataSource dataSource) {
        this.dataSource_ = dataSource;
    }

    public DaoMetaData getDaoMetaData(Class daoClass) {
        String key = daoClass.getName();
        DaoMetaData dmd = (DaoMetaData)this.daoMetaDataCache_.get(key);
        if (dmd != null) {
            return dmd;
        }
        DaoMetaDataFactory daoMetaDataFactory = this;
        synchronized (daoMetaDataFactory) {
            dmd = (DaoMetaData)this.daoMetaDataCache_.get(key);
            if (dmd != null) {
                return dmd;
            }
            dmd = new DaoMetaDataImpl(daoClass, this.dataSource_);
            this.daoMetaDataCache_.put(key, dmd);
        }
        return dmd;
    }
}

