package org.seasar.dao.impl;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import org.seasar.dao.DaoMetaData;

/**
 * @author higa
 *  
 */
public class DaoMetaDataFactory {

	private Map daoMetaDataCache_ = new HashMap();
	
	private DataSource dataSource_;

	public DaoMetaDataFactory(DataSource dataSource) {
		dataSource_ = dataSource;
	}
	
	public DaoMetaData getDaoMetaData(Class daoClass) {
		String key = daoClass.getName();
		DaoMetaData dmd = (DaoMetaData) daoMetaDataCache_.get(key);
		if (dmd != null) {
			return dmd;
		}
		synchronized (this) {
			dmd = (DaoMetaData) daoMetaDataCache_.get(key);
			if (dmd != null) {
				return dmd;
			}
			dmd = new DaoMetaDataImpl(daoClass, dataSource_);
			daoMetaDataCache_.put(key, dmd);
		}
		return dmd;
	}
}