/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class ShortConversionUtil {
    private ShortConversionUtil() {
    }

    public static Short toShort(Object o) {
        return ShortConversionUtil.toShort(o, null);
    }

    public static Short toShort(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Number) {
            return new Short(((Number)o).shortValue());
        }
        if (o instanceof String) {
            return new Short((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Short(new SimpleDateFormat(pattern).format(o));
            }
            return new Short((short)((Date)o).getTime());
        }
        return new Short(o.toString());
    }

    public static short toPrimitiveShort(Object o) {
        return ShortConversionUtil.toPrimitiveShort(o, null);
    }

    public static short toPrimitiveShort(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof String) {
            return Short.parseShort((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Short.parseShort(new SimpleDateFormat(pattern).format(o));
            }
            return (short)((Date)o).getTime();
        }
        return Short.parseShort(o.toString());
    }
}

