/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.SelectHandler;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.extension.jdbc.impl.BasicResultSetFactory;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

public class BasicSelectHandler
extends BasicHandler
implements SelectHandler {
    private static Logger logger_;
    private static ResultSetFactory resultSetFactory_;
    private ResultSetHandler resultSetHandler_;
    private int fetchSize_ = 100;
    private int maxRows_ = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.extension.jdbc.impl.BasicSelectHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        resultSetFactory_ = new BasicResultSetFactory();
    }

    public BasicSelectHandler() {
    }

    public BasicSelectHandler(DataSource dataSource, String sql, ResultSetHandler resultSetHandler) {
        this.setDataSource(dataSource);
        this.setSql(sql);
        this.setResultSetHandler(resultSetHandler);
    }

    public static synchronized void register(ResultSetFactory resultSetFactory) {
        resultSetFactory_ = resultSetFactory;
    }

    public ResultSetHandler getResultSetHandler() {
        return this.resultSetHandler_;
    }

    public void setResultSetHandler(ResultSetHandler resultSetHandler) {
        this.resultSetHandler_ = resultSetHandler;
    }

    public int getFetchSize() {
        return this.fetchSize_;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize_ = fetchSize;
    }

    public int getMaxRows() {
        return this.maxRows_;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows_ = maxRows;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object[] args) throws SQLRuntimeException {
        Object object;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)this.getCompleteSql(args));
        }
        Connection con = this.getConnection();
        try {
            try {
                object = this.execute(con, args);
                Object var4_4 = null;
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ConnectionUtil.close((Connection)con);
            throw throwable;
        }
        ConnectionUtil.close((Connection)con);
        return object;
    }

    protected Object execute(Connection connection, Object[] args) throws SQLException {
        Object object;
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(connection);
            this.bindArgs(ps, args);
            object = this.execute(ps);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            StatementUtil.close((Statement)ps);
            throw throwable;
        }
        StatementUtil.close((Statement)ps);
        return object;
    }

    protected Object[] setup(Connection con, Object[] args) throws SQLException {
        return args;
    }

    protected PreparedStatement prepareStatement(Connection connection) {
        PreparedStatement ps = super.prepareStatement(connection);
        if (this.fetchSize_ > -1) {
            StatementUtil.setFetchSize((Statement)ps, (int)this.fetchSize_);
        }
        if (this.maxRows_ > -1) {
            StatementUtil.setMaxRows((Statement)ps, (int)this.maxRows_);
        }
        return ps;
    }

    protected Object execute(PreparedStatement ps) throws SQLException {
        Object object;
        if (this.resultSetHandler_ == null) {
            throw new EmptyRuntimeException("resultSetHandler");
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.createResultSet(ps);
            object = this.resultSetHandler_.handle(resultSet);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ResultSetUtil.close((ResultSet)resultSet);
            throw throwable;
        }
        ResultSetUtil.close((ResultSet)resultSet);
        return object;
    }

    protected void setupDatabaseMetaData(DatabaseMetaData dbMetaData) throws SQLException {
    }

    protected ResultSet createResultSet(PreparedStatement ps) throws SQLException {
        return resultSetFactory_.createResultSet(ps);
    }
}

