package test.org.seasar.dao.impl;

import org.seasar.dao.impl.BeanMetaDataFactory;
import org.seasar.dao.impl.UpdateBatchAutoStaticCommand;
import org.seasar.extension.unit.S2TestCase;

public class UpdateBatchAutoStaticCommandTest extends S2TestCase {

	public UpdateBatchAutoStaticCommandTest(String arg0) {
		super(arg0);
	}

	public void testExecuteTx() throws Exception {
		UpdateBatchAutoStaticCommand cmd = new UpdateBatchAutoStaticCommand(
				BeanMetaDataFactory.getBeanMetaData(Employee.class));
		Employee emp = new Employee();
		emp.setEmpno(7788);
		emp.setEname("hoge");
		Employee emp2 = new Employee();
		emp2.setEmpno(7369);
		emp2.setEname("hoge2");
		Integer count = (Integer) cmd.execute(getDataSource(),
				new Object[] { new Employee[] { emp, emp2 } });
		assertEquals("1", new Integer(2), count);
	}

	public void setUp() {
		include("j2ee.dicon");
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(UpdateBatchAutoStaticCommandTest.class);
	}

}