package test.org.seasar.dao.impl;

import org.seasar.dao.DaoMetaData;
import org.seasar.dao.IllegalSignatureRuntimeException;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.dbms.HSQL;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.DeleteBatchAutoStaticCommand;
import org.seasar.dao.impl.InsertAutoStaticCommand;
import org.seasar.dao.impl.InsertBatchAutoStaticCommand;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.impl.UpdateBatchAutoStaticCommand;
import org.seasar.dao.impl.UpdateDynamicCommand;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;
import org.seasar.extension.unit.S2TestCase;

/**
 * @author higa
 *
 */
public class DaoMetaDataImplTest extends S2TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public DaoMetaDataImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(DaoMetaDataImplTest.class);
	}
	
	public void setUp() {
		include("j2ee.dicon");
	}

	public void testSelectBeanList() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class,
				DbmsManager.getDbms(""), getDataSource());
		SelectDynamicCommand cmd = (SelectDynamicCommand) dmd.getSqlCommand("getAllEmployees");
		assertNotNull("1", cmd);
		assertEquals("2", "SELECT * FROM emp", cmd.getSql());
		BeanListMetaDataResultSetHandler rsh = (BeanListMetaDataResultSetHandler) cmd.getResultSetHandler();
		assertEquals("3", Employee.class, rsh.getBeanClass());
	}
	
	public void testSelectBean() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class,
				DbmsManager.getDbms(""), getDataSource());
		SelectDynamicCommand cmd = (SelectDynamicCommand) dmd.getSqlCommand("getEmployee");
		assertNotNull("1", cmd);
		assertEquals("2", BeanMetaDataResultSetHandler.class, cmd.getResultSetHandler().getClass());
		assertEquals("3", "empno", cmd.getArgNames()[0]);
	}
	
	public void testSelectObject() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class,
				new HSQL(), getDataSource());
		SelectDynamicCommand cmd = (SelectDynamicCommand) dmd.getSqlCommand("getCount");
		assertNotNull("1", cmd);
		assertEquals("2", ObjectResultSetHandler.class, cmd.getResultSetHandler().getClass());
		assertEquals("3", "SELECT COUNT(*) FROM emp", cmd.getSql());
	}
	
	public void testUpdate() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class,
				DbmsManager.getDbms(""), getDataSource());
		UpdateDynamicCommand cmd = (UpdateDynamicCommand) dmd.getSqlCommand("update");
		assertNotNull("1", cmd);
		assertEquals("2", "employee", cmd.getArgNames()[0]);
	}
	
	public void testInsertAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				DbmsManager.getDbms(""), getDataSource());
		InsertAutoStaticCommand cmd = (InsertAutoStaticCommand) dmd.getSqlCommand("insert");
		assertNotNull("1", cmd);
	}
	
	public void testUpdateAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				DbmsManager.getDbms(""), getDataSource());
		assertNotNull("1", dmd.getSqlCommand("update"));
	}
	
	public void testDeleteAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				DbmsManager.getDbms(""), getDataSource());
		assertNotNull("1", dmd.getSqlCommand("delete"));
	}
	
	public void testIllegalAutoUpdateMethod() throws Exception {
		try {
			new DaoMetaDataImpl(IllegalEmployeeAutoDao.class,
					DbmsManager.getDbms(""), getDataSource());
			fail("1");
		} catch (IllegalSignatureRuntimeException ex) {
			System.out.println(ex.getSignature());
			System.out.println(ex);
		}
	}
	
	public void testSelectAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				DbmsManager.getDbms(""), getDataSource());
		SelectDynamicCommand cmd = (SelectDynamicCommand)
			dmd.getSqlCommand("getEmployeeByDeptno");
		System.out.println(cmd.getSql());
	}
	
	public void testInsertBatchAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				DbmsManager.getDbms(""), getDataSource());
		InsertBatchAutoStaticCommand cmd = (InsertBatchAutoStaticCommand) dmd.getSqlCommand("insertBatch");
		assertNotNull("1", cmd);
	}
	
	public void testUpdateBatchAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				DbmsManager.getDbms(""), getDataSource());
		UpdateBatchAutoStaticCommand cmd = (UpdateBatchAutoStaticCommand) dmd.getSqlCommand("updateBatch");
		assertNotNull("1", cmd);
	}
	
	public void testDeleteBatchAuto() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				DbmsManager.getDbms(""), getDataSource());
		DeleteBatchAutoStaticCommand cmd = (DeleteBatchAutoStaticCommand) dmd.getSqlCommand("deleteBatch");
		assertNotNull("1", cmd);
	}
}