package test.org.seasar.dao.impl;

import java.sql.DatabaseMetaData;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.unit.S2TestCase;

/**
 * @author higa
 *
 */
public class BeanMetaDataImplTest extends S2TestCase {
	
	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public BeanMetaDataImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(BeanMetaDataImplTest.class);
	}
	
	protected void setUp() throws Exception {
		include("j2ee.dicon");
	}

	protected void tearDown() throws Exception {
	}

	public void testSetup() throws Exception {
		BeanMetaData bmd = new BeanMetaDataImpl(MyBean.class);
		assertEquals("1", "MyBean", bmd.getTableName());
		assertEquals("2", 3, bmd.getPropertyTypeSize());
		PropertyType aaa = bmd.getPropertyType("aaa");
		assertEquals("3", "aaa", aaa.getColumnName());
		PropertyType bbb = bmd.getPropertyType("bbb");
		assertEquals("4", "myBbb", bbb.getColumnName());
		assertEquals("5", 1, bmd.getRelationPropertyTypeSize());
		RelationPropertyType rpt = bmd.getRelationPropertyType(0);
		assertEquals("6", 1, rpt.getKeySize());
		assertEquals("7", "ddd", rpt.getMyKey(0));
		assertEquals("8", "id", rpt.getYourKey(0));
	}
	
	public void testSetupDatabaseMetaData() throws Exception {
		DatabaseMetaData dbMetaData = getConnection().getMetaData();
		BeanMetaData bmd = new BeanMetaDataImpl(Employee.class);
		bmd.setupDatabaseMetaData(dbMetaData);
		PropertyType empno = bmd.getPropertyType("empno");
		assertEquals("1", true, empno.isPrimaryKey());
		assertEquals("2", true, empno.isPersistent());
		PropertyType ename = bmd.getPropertyType("ename");
		assertEquals("3", false, ename.isPrimaryKey());
		PropertyType dummy = bmd.getPropertyType("dummy");
		assertEquals("4", false, dummy.isPersistent());
	}
	
	public void testSetupAutoInsertSql() throws Exception {
		DatabaseMetaData dbMetaData = getConnection().getMetaData();
		BeanMetaData bmd = new BeanMetaDataImpl(Employee.class);
		bmd.setupDatabaseMetaData(dbMetaData);
		System.out.println(bmd.getAutoInsertSql());
	}
	
	public void testSetupAutoUpdateSql() throws Exception {
		DatabaseMetaData dbMetaData = getConnection().getMetaData();
		BeanMetaData bmd = new BeanMetaDataImpl(Department.class);
		BeanMetaData bmd2 = new BeanMetaDataImpl(Employee.class);
		bmd.setupDatabaseMetaData(dbMetaData);
		bmd2.setupDatabaseMetaData(dbMetaData);
		System.out.println(bmd.getAutoUpdateSql());
		System.out.println(bmd2.getAutoUpdateSql());
	}
	
	public void testSetupAutoDeleteSql() throws Exception {
		DatabaseMetaData dbMetaData = getConnection().getMetaData();
		BeanMetaData bmd = new BeanMetaDataImpl(Department.class);
		BeanMetaData bmd2 = new BeanMetaDataImpl(Employee.class);
		bmd.setupDatabaseMetaData(dbMetaData);
		bmd2.setupDatabaseMetaData(dbMetaData);
		System.out.println(bmd.getAutoDeleteSql());
		System.out.println(bmd2.getAutoDeleteSql());
	}
	
	public void testSetupAutoSelectList() throws Exception {
		DatabaseMetaData dbMetaData = getConnection().getMetaData();
		BeanMetaData bmd = new BeanMetaDataImpl(Department.class);
		BeanMetaData bmd2 = new BeanMetaDataImpl(Employee.class);
		bmd.setupDatabaseMetaData(dbMetaData);
		bmd2.setupDatabaseMetaData(dbMetaData);
		String sql = bmd.getAutoSelectList();
		String sql2 = bmd2.getAutoSelectList();
		System.out.println(sql);
		System.out.println(sql2);
		
		assertTrue("1", sql2.indexOf("EMP.deptno") > 0);
		assertTrue("2", sql2.indexOf("department.deptno AS deptno_0") > 0);
		assertTrue("3", sql2.indexOf("dummy_0") < 0);
	}
	
	public void testConvertFullColumnName() throws Exception {
		BeanMetaData bmd = new BeanMetaDataImpl(Employee.class);
		assertEquals("1", "EMP.empno", bmd.convertFullColumnName("empno"));
		assertEquals("2", "department.dname", bmd.convertFullColumnName("dname_0"));
	}
	
	public static class MyBean {
		public static final String TABLE = "MyBean";
		public static final String PK = "aaa, myBbb";
		public static final String bbb_COLUMN = "myBbb";
		public static final int ccc_RELNO = 0;
		public static final String ccc_RELKEYS = "ddd:id";
		
		private Integer aaa_;
		private String bbb_;
		private Ccc ccc_;
		private Integer ddd_;
		
		public Integer getAaa() {
			return aaa_;
		}
		
		public void setAaa(Integer aaa) {
			aaa_ = aaa;
		}
		
		public String getBbb() {
			return bbb_;
		}
		
		public void setBbb(String bbb) {
			bbb_ = bbb;
		}
		
		public Ccc getCcc() {
			return ccc_;
		}
		
		public void setCcc(Ccc ccc) {
			ccc_ = ccc;
		}
		
		public Integer getDdd() {
			return ddd_;
		}
		
		public void setDdd(Integer ddd) {
			ddd_ = ddd;
		}
	}
	
	public static class Ccc {
		private Integer id_;
		public Integer getId() {
			return id_;
		}
		public void setId(Integer id) {
			id_ = id;
		}
	}
}