package org.seasar.dao.node;

import java.util.List;

import org.seasar.dao.CommandContext;
import org.seasar.framework.util.OgnlUtil;

/**
 * @author higa
 *  
 */
public class ParenBindVariableNode extends AbstractNode {

	private String expression_;
	private Object parsedExpression_;

	public ParenBindVariableNode(String expression) {
		expression_ = expression;
		parsedExpression_ = OgnlUtil.parseExpression(expression);
	}

	public String getExpression() {
		return expression_;
	}

	/**
	 * @see org.seasar.dao.Node#accept(org.seasar.dao.QueryContext)
	 */
	public void accept(CommandContext ctx) {
		Object var = OgnlUtil.getValue(parsedExpression_, ctx);
		if (var instanceof List) {
			bindArray(ctx, ((List) var).toArray());
		} else if (var instanceof Object[]) {
			bindArray(ctx, (Object[]) var);
		} else {
			ctx.addSql("?", var);
		}

	}

	private void bindArray(CommandContext ctx, Object[] array) {
		if (array.length == 0) {
			return;
		}
		ctx.addSql("(");
		ctx.addSql("?", array[0]);
		for (int i = 1; i < array.length; ++i) {
			ctx.addSql(", ?", array[i]);
		}
		ctx.addSql(")");
	}
}