package org.seasar.framework.container.factory;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.EmptyRuntimeException;

public final class SingletonS2ContainerFactory {

	private static String configPath_ = "app.dicon";
	private static S2Container container_;
	
	private SingletonS2ContainerFactory() {
	}
	
	public static String getConfigPath() {
		return configPath_;
	}
	
	public static void setConfigPath(String configPath) {
		configPath_ = configPath;
	}

	public static void init() {
		container_ = S2ContainerFactory.create(configPath_);
		container_.init();
	}
	
	public static void destroy() {
		container_.destroy();
		container_ = null;
	}
	
	public static S2Container getContainer() {
		if (container_ == null) {
			throw new EmptyRuntimeException("S2Container");
		}
		return container_;
	}
	
	public static boolean hasContainer() {
		return container_ != null;
	}
}
