package org.seasar.dao.impl;

import javax.sql.DataSource;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.CommandContext;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.SelectHandler;

/**
 * @author higa
 *  
 */
public class SelectDynamicCommand extends AbstractDynamicCommand {

	private BeanMetaData beanMetaData_;
	private ResultSetHandler resultSetHandler_;
	
	public SelectDynamicCommand(BeanMetaData beanMetaData,
			ResultSetHandler resultSetHandler) {
		
		beanMetaData_ = beanMetaData;
		resultSetHandler_ = resultSetHandler;
	}
	
	public ResultSetHandler getResultSetHandler() {
		return resultSetHandler_;
	}

	public Object execute(DataSource ds, Object[] args) {
		
		CommandContext ctx = apply(args);
		SelectHandler selectHandler =
			new SelectDynamicHandler(ds, ctx.getSql(),
					resultSetHandler_, beanMetaData_);
		return selectHandler.execute(ctx.getBindVariables());
	}

}