package org.seasar.dao.dialect;

import java.util.HashMap;
import java.util.Map;

import org.seasar.dao.Dialect;

/**
 * @author higa
 *
 */
public final class DialectManager {

	private static Map dialects_ = new HashMap();
	private static Dialect dialect_;
	
	static {
		dialects_.put("Oracle", new OracleDialect());
	}

	private DialectManager() {
	}
	
	public static synchronized void register(Dialect dialect) {
		dialect_ = dialect;
	}
	
	public static void setupDialect(String productName) {
		if (dialect_ != null) {
			return;
		}
		synchronized (DialectManager.class) {
			if (dialect_ != null) {
				return;
			}
			dialect_ = (Dialect) dialects_.get(productName);
			if (dialect_ == null) {
				dialect_ = new BasicDialect();
			}
		}
	}

	public static Dialect getDialect() {
		return dialect_;
	}
}
