package test.org.seasar.dao.command;

import org.seasar.dao.command.SelectCommand;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.BeanResultSetHandler;
import org.seasar.extension.unit.S2TestCase;

public class SelectCommandTest extends S2TestCase {

	private ResultSetHandler resultSetHandler_ =
		new BeanResultSetHandler(Employee.class);

	public SelectCommandTest(String arg0) {
		super(arg0);
	}

	public void testExecute() throws Exception {
		SelectCommand cmd = new SelectCommand();
		cmd.setSql("SELECT * FROM emp WHERE empno = /*empno*/1234");
		cmd.setArgNames(new String[]{"empno"});
		cmd.setResultSetHandler(resultSetHandler_);
		Employee emp = (Employee) cmd.execute(getDataSource(), new Object[]{new Integer(7788)});
		System.out.println(emp);
		assertNotNull("1", emp);
	}

	public void setUp() {
		include("j2ee.dicon");
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(SelectCommandTest.class);
	}

}
