package org.seasar.framework.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

import org.seasar.framework.exception.IORuntimeException;

/**
 * @author higa
 *
 */
public final class ReaderUtil {

	private ReaderUtil() {
	}

	public static String readText(Reader reader) {
		BufferedReader in = new BufferedReader(reader);
		StringBuffer out = new StringBuffer(100);
		try {
			try {
				String line = null;
				while ((line = in.readLine()) != null) {
					out.append(line);
					out.append('\n');
				}
				int lastPos = out.length() - 1;
		        if (lastPos >= 0 && out.charAt(lastPos) == '\n') {
		            out.setLength(lastPos);
		        }
			} finally {
				in.close();
			}
		} catch (IOException e) {
			throw new IORuntimeException(e);
		}
		return out.toString();
	}

}
