package org.seasar.extension.jdbc.impl;

import org.seasar.extension.jdbc.BeanMetaData;
import org.seasar.extension.jdbc.RelationPropertyType;
import org.seasar.framework.beans.PropertyDesc;

/**
 * @author higa
 *  
 */
public class RelationPropertyTypeImpl extends PropertyTypeImpl
		implements
			RelationPropertyType {

	private int relationNo_;
	private String[] myKeys_;
	private String[] yourKeys_;
	private BeanMetaData beanMetaData_;

	public RelationPropertyTypeImpl(PropertyDesc propertyDesc, int relationNo,
			String[] myKeys, String[] yourKeys) {

		super(propertyDesc);
		relationNo_ = relationNo;
		myKeys_ = myKeys;
		yourKeys_ = yourKeys;
		Class beanClass = propertyDesc.getPropertyType();
		beanMetaData_ = BeanMetaDataFactory.getBeanMetaData(beanClass);
	}

	public int getRelationNo() {
		return relationNo_;
	}

	/**
	 * @see org.seasar.extension.jdbc.RelationPropertyType#getKeySize()
	 */
	public int getKeySize() {
		if (myKeys_.length > 0) {
			return myKeys_.length;
		} else {
			return beanMetaData_.getPrimaryKeySize();
		}
		
	}

	/**
	 * @see org.seasar.extension.jdbc.RelationPropertyType#getMyKey(int)
	 */
	public String getMyKey(int index) {
		if (myKeys_.length > 0) {
			return myKeys_[index];
		} else {
			return beanMetaData_.getPrimaryKey(index);
		}
	}

	/**
	 * @see org.seasar.extension.jdbc.RelationPropertyType#getYourKey(int)
	 */
	public String getYourKey(int index) {
		if (yourKeys_.length > 0) {
			return yourKeys_[index];
		} else {
			return beanMetaData_.getPrimaryKey(index);
		}
	}
	
	/**
	 * @see org.seasar.extension.jdbc.RelationPropertyType#getBeanMetaData()
	 */
	public BeanMetaData getBeanMetaData() {
		return beanMetaData_;
	}
}