package org.maachang.rimdb.util;

/**
 * 数字Key数字Value子要素.
 * 
 * @version 2014/07/21
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class NNChild {
	public int o;
	protected int b;
	protected NNChild n;

	/**
	 * コンストラクタ.
	 * 
	 * @param k
	 *            対象のキーを設定します.
	 * @param v
	 *            対象の要素を設定します.
	 */
	protected NNChild(int k, int v) {
		b = k;
		o = v;
	}

	/**
	 * 対象のキーを取得.
	 * 
	 * @return int 対象のキーコードが返却されます.
	 */
	public final int getKey() {
		return b;
	}

	/**
	 * 対象の要素を取得.
	 * 
	 * @return int 対象の要素が返却されます.
	 */
	public final int getValue() {
		return o;
	}

	/**
	 * 対象の要素を変更.
	 * 
	 * @param v
	 *            要素を設定します.
	 */
	public final void setValue(final int v) {
		o = v;
	}

}
