package org.maachang.rimdb.util;

import java.io.File;

import org.maachang.rimdb.RimDbException;

/**
 * ファイルユーティリティ.
 * 
 * @version 2014/07/10
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class FileUtil {
	protected FileUtil() {
	}

	/**
	 * ファイル名の存在チェック.
	 * 
	 * @param name
	 *            対象のファイル名を設定します.
	 * @return boolean [true]の場合、ファイルは存在します.
	 */
	public static final boolean isFile(String name) {
		File file = new File(name);
		return (file.exists() && !file.isDirectory());
	}

	/**
	 * ファイル名のフルパスを取得.
	 * 
	 * @param name
	 *            対象のファイル名を設定します.
	 * @return String フルパス名が返却されます.
	 * @exception Exception
	 *                例外.
	 */
	public static final String getFullPath(String name) {
		try {
			File f = new File(name);
			String s = f.getCanonicalPath();
			if (s.indexOf("\\") != -1) {
				s = ConvertUtil.changeString(s, "\\", "/");
			}
			if (!s.startsWith("/")) {
				s = "/" + s;
			}
			return s;
		} catch (Exception e) {
			throw new RimDbException(e);
		}
	}
}
