package org.maachang.rimdb.table.array;

import org.maachang.rimdb.ColumnType;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.util.NList;

/**
 * Time配列.
 * 
 * @version 2014/07/07
 * @author masahito suzuki
 * @since rimdb-1.00
 */
@SuppressWarnings("deprecation")
public final class TimeArray implements ColumnArray<java.sql.Time> {
	private int[] list;
	private int[] nullList;

	/**
	 * コンストラクタ.
	 * 
	 * @param columns
	 *            カラム群を設定します.
	 */
	public TimeArray(final java.util.Date[] columns) {
		java.util.Date t;
		final NList nulls = new NList();
		final int len = columns.length;
		final int[] n = new int[len];
		for (int i = 0; i < len; i++) {
			if (columns[i] == null) {
				nulls.add(i);
			} else {
				t = columns[i];
				n[i] = (int) (new java.sql.Time(t.getHours(), t.getMinutes(), t
						.getSeconds())).getTime();
			}
		}
		list = n;
		if (nulls.size() == 0) {
			nullList = null;
		} else {
			nullList = nulls.sort().getArray();
		}
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param columns
	 *            カラム群を設定します.
	 */
	public TimeArray(final java.sql.Time[] columns) {
		java.sql.Time t;
		final NList nulls = new NList();
		final int len = columns.length;
		final int[] n = new int[len];
		for (int i = 0; i < len; i++) {
			if (columns[i] == null) {
				nulls.add(i);
			} else {
				t = columns[i];
				n[i] = (int) (new java.sql.Time(t.getHours(), t.getMinutes(), t
						.getSeconds())).getTime();
			}
		}
		list = n;
		if (nulls.size() == 0) {
			nullList = null;
		} else {
			nullList = nulls.sort().getArray();
		}
	}

	/**
	 * カラムタイプを取得.
	 * 
	 * @return int カラムタイプが返却されます.
	 */
	public final int getType() {
		return ColumnType.TYPE_TIME;
	}

	/**
	 * 指定位置の情報を取得.
	 * 
	 * @param no
	 *            対象の項番を設定します.
	 * @return java.sql.Time 情報が返却されます.
	 */
	public final java.sql.Time get(final int no) {
		if (nullList != null && IndexUtil.searchInt(nullList, no) != -1) {
			return null;
		}
		return new java.sql.Time((long) list[no]);
	}

	/**
	 * 指定位置の情報を取得.
	 * 
	 * @param out
	 *            出力対象の情報を設定します.
	 * @param no
	 *            対象の項番を設定します.
	 * @return java.sql.Time 情報が返却されます.
	 */
	public final java.sql.Time get(final java.sql.Time out, final int no) {
		if (nullList != null && IndexUtil.searchInt(nullList, no) != -1) {
			return null;
		}
		out.setTime((long) list[no]);
		return out;
	}

}
