package org.maachang.rimdb.table.array;

import org.maachang.rimdb.ColumnType;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.util.NList;
import org.maachang.rimdb.util.OList;

/**
 * Double配列.
 * 
 * @version 2014/07/07
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class StringArray implements ColumnArray<String> {
	private char[] list;
	private int[] posList;
	private int[] nullList;

	/**
	 * コンストラクタ.
	 * 
	 * @param columns
	 *            カラム群を設定します.
	 */
	public StringArray(final String[] columns) {
		char[] c;
		final NList nulls = new NList();
		final OList<char[]> n = new OList<char[]>();
		final int len = columns.length;

		int i, cnt;
		cnt = 0;
		for (i = 0; i < len; i++) {
			if (columns[i] == null) {
				nulls.add(i);
				n.add(null);
			} else {
				c = columns[i].toCharArray();
				cnt += c.length;
				n.add(c);
			}
		}
		final int nLen = n.size();
		final char[] cc = new char[cnt];
		final int[] plst = new int[nLen + 1];
		cnt = 0;
		plst[0] = 0;
		for (i = 0; i < len; i++) {
			if ((c = n.get(i)) != null) {
				System.arraycopy(c, 0, cc, cnt, c.length);
				cnt += c.length;
			}
			plst[i + 1] = cnt;
		}
		n.clear();
		list = cc;
		posList = plst;

		if (nulls.size() == 0) {
			nullList = null;
		} else {
			nullList = nulls.sort().getArray();
		}
	}

	/**
	 * カラムタイプを取得.
	 * 
	 * @return int カラムタイプが返却されます.
	 */
	public final int getType() {
		return ColumnType.TYPE_STRING;
	}

	/**
	 * 指定位置の情報を取得.
	 * 
	 * @param no
	 *            対象の項番を設定します.
	 * @return String 情報が返却されます.
	 */
	public final String get(final int no) {
		if (nullList != null && IndexUtil.searchInt(nullList, no) != -1) {
			return null;
		}
		final int n = posList[no];
		return new String(list, n, posList[no + 1] - n);
	}

}
