package org.maachang.rimdb.table.array;

import org.maachang.rimdb.ColumnType;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.util.NList;

/**
 * Int配列.
 * 
 * @version 2014/07/07
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class IntegerArray implements ColumnArray<Integer> {
	private int[] list;
	private int[] nullList;

	/**
	 * コンストラクタ.
	 * 
	 * @param columns
	 *            カラム群を設定します.
	 */
	public IntegerArray(final Integer[] columns) {
		final NList nulls = new NList();
		final int len = columns.length;
		final int[] n = new int[len];
		for (int i = 0; i < len; i++) {
			if (columns[i] == null) {
				nulls.add(i);
			} else {
				n[i] = columns[i];
			}
		}
		list = n;
		if (nulls.size() == 0) {
			nullList = null;
		} else {
			nullList = nulls.sort().getArray();
		}
	}

	/**
	 * カラムタイプを取得.
	 * 
	 * @return int カラムタイプが返却されます.
	 */
	public final int getType() {
		return ColumnType.TYPE_INT;
	}

	/**
	 * 指定位置の情報を取得.
	 * 
	 * @param no
	 *            対象の項番を設定します.
	 * @return Inreger 情報が返却されます.
	 */
	public final Integer get(final int no) {
		if (nullList != null && IndexUtil.searchInt(nullList, no) != -1) {
			return null;
		}
		return list[no];
	}

	/**
	 * int配列を取得.
	 * 
	 * @return int[] 配列が返却されます.
	 */
	public final int[] getArray() {
		return list;
	}

}
