package org.maachang.rimdb.table.array;

import org.maachang.rimdb.ColumnType;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.util.NList;

/**
 * Date配列.
 * 
 * @version 2014/07/07
 * @author masahito suzuki
 * @since rimdb-1.00
 */
@SuppressWarnings("deprecation")
public final class DateArray implements ColumnArray<java.sql.Date> {
	private long[] list;
	private int[] nullList;

	/**
	 * コンストラクタ.
	 * 
	 * @param columns
	 *            カラム群を設定します.
	 */
	public DateArray(final java.util.Date[] columns) {
		java.util.Date d;
		final NList nulls = new NList();
		final int len = columns.length;
		final long[] n = new long[len];
		for (int i = 0; i < len; i++) {
			if (columns[i] == null) {
				nulls.add(i);
			} else {
				d = columns[i];
				n[i] = new java.sql.Date(d.getYear(), d.getMonth(), d.getDate())
						.getTime();
			}
		}
		list = n;
		if (nulls.size() == 0) {
			nullList = null;
		} else {
			nullList = nulls.sort().getArray();
		}
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param columns
	 *            カラム群を設定します.
	 */
	public DateArray(final java.sql.Date[] columns) {
		java.sql.Date d;
		final NList nulls = new NList();
		final int len = columns.length;
		final long[] n = new long[len];
		for (int i = 0; i < len; i++) {
			if (columns[i] == null) {
				nulls.add(i);
			} else {
				d = columns[i];
				n[i] = new java.sql.Date(d.getYear(), d.getMonth(), d.getDate())
						.getTime();
			}
		}
		list = n;
		if (nulls.size() == 0) {
			nullList = null;
		} else {
			nullList = nulls.sort().getArray();
		}
	}

	/**
	 * カラムタイプを取得.
	 * 
	 * @return int カラムタイプが返却されます.
	 */
	public final int getType() {
		return ColumnType.TYPE_DATE;
	}

	/**
	 * 指定位置の情報を取得.
	 * 
	 * @param no
	 *            対象の項番を設定します.
	 * @return java.sql.Date 情報が返却されます.
	 */
	public final java.sql.Date get(final int no) {
		if (nullList != null && IndexUtil.searchInt(nullList, no) != -1) {
			return null;
		}
		return new java.sql.Date(list[no]);
	}

	/**
	 * 指定位置の情報を取得.
	 * 
	 * @param out
	 *            出力対象の情報を設定します.
	 * @param no
	 *            対象の項番を設定します.
	 * @return java.sql.Date 情報が返却されます.
	 */
	public final java.sql.Date get(final java.sql.Date out, final int no) {
		if (nullList != null && IndexUtil.searchInt(nullList, no) != -1) {
			return null;
		}
		out.setTime(list[no]);
		return out;
	}

}
