package org.maachang.rimdb.search;

import org.maachang.rimdb.index.Pointer;
import org.maachang.rimdb.index.SearchPointer;

/**
 * 検索ポインター
 * 
 * @version 2014/07/13
 * @author masahito suzuki
 * @since rimdb-1.00
 */
@SuppressWarnings("unchecked")
public final class PointerBlock implements Block<SearchPointer> {
	protected PointerBlock() {
	}

	/** 検索ポインタ. **/
	private SearchPointer PointerBlock;

	/** ブロックタイプ. **/
	private int type;

	/**
	 * コンストラクタ.
	 * 
	 * @param t
	 *            対象の検索タイプを設定します.
	 * @param p
	 *            対象の検索ポインタを設定します.
	 */
	protected PointerBlock(int t, Pointer p) {
		PointerBlock = (SearchPointer) p;
		type = t;
	}

	/**
	 * ブロックタイプを取得.
	 * 
	 * @return int ブロックタイプが返却されます.
	 */
	public final int getType() {
		return type;
	}

	/**
	 * 検索ポインタリストを取得.
	 * 
	 * @return SearchPointer 検索ポインタリストが返却されます.
	 */
	public final SearchPointer get() {
		return PointerBlock;
	}

	/**
	 * 文字情報表示.
	 * 
	 * @return String 文字情報を表示します.
	 */
	public final String toString() {
		return new StringBuilder(" [PointerBlock]:[").append(type).append("] ")
				.append(PointerBlock).toString();
	}
}
