package org.maachang.rimdb.index.string;

import org.maachang.rimdb.index.WherePointer;

/**
 * String(IString)大なり(>)ポインタ.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class StringBig extends WherePointer<IString> {
	protected StringBig() {
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            [>=]で検索する場合は[true]をセット.
	 */
	public StringBig(StringIndex index, boolean eq) {
		if (eq) {
			this.type = TYPE_GE;
		} else {
			this.type = TYPE_GT;
		}
		this.columnName = index.getColumnName();
		this.eq = eq;
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            [>=]で検索する場合は[true]をセット.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public StringBig(StringIndex index, boolean eq, IString word) {
		this(index, eq);
		set(word);
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            [>=]で検索する場合は[true]をセット.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public StringBig(StringIndex index, boolean eq, String word) {
		this(index, eq);
		set(new IString(word));
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            [>=]で検索する場合は[true]をセット.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public StringBig(StringIndex index, boolean eq, Object word) {
		this(index, eq);
		parameter(word);
	}

	/**
	 * 情報セット.
	 * 
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public final void parameter(final Object word) {
		set(StringIn.convert(word));
	}

	/**
	 * オブジェクトコピー.
	 * 
	 * @param mode
	 *            [true]を設定した場合、パラメータ情報はコピーされません.
	 * @return SearchPointer コピーされたオブジェクトが返却されます.
	 */
	public final StringBig copy(final boolean mode) {
		StringBig ret = new StringBig();
		baseCopy(mode, ret);
		return ret;
	}
}
