package org.maachang.rimdb.index.string;

import org.maachang.rimdb.index.BetweenPointer;

/**
 * String(IString)一致ポインタ.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class StringBetween extends BetweenPointer<IString> {
	protected StringBetween() {
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 */
	public StringBetween(StringIndex index) {
		this.type = TYPE_BETWEEN;
		this.columnName = index.getColumnName();
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param start
	 *            対象の開始検索ワードを設定します.
	 * @param end
	 *            対象の終了検索ワードを設定します.
	 */
	public StringBetween(StringIndex index, IString start, IString end) {
		this(index);
		set(start, end);
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param start
	 *            対象の開始検索ワードを設定します.
	 * @param end
	 *            対象の終了検索ワードを設定します.
	 */
	public StringBetween(StringIndex index, String start, String end) {
		this(index);
		set(new IString(start), new IString(end));
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param start
	 *            対象の開始検索ワードを設定します.
	 * @param end
	 *            対象の終了検索ワードを設定します.
	 */
	public StringBetween(StringIndex index, Object start, Object end) {
		this(index);
		parameter(start, end);
	}

	/**
	 * 情報セット.
	 * 
	 * @param start
	 *            対象の開始ワード情報を設定します.
	 * @param end
	 *            対象の終了ワード情報を設定します.
	 */
	public final void parameter(final Object start, final Object end) {
		set(StringIn.convert(start), StringIn.convert(end));
	}

	/**
	 * オブジェクトコピー.
	 * 
	 * @param mode
	 *            [true]を設定した場合、パラメータ情報はコピーされません.
	 * @return SearchPointer コピーされたオブジェクトが返却されます.
	 */
	public final StringBetween copy(final boolean mode) {
		StringBetween ret = new StringBetween();
		baseCopy(mode, ret);
		return ret;
	}
}
