package org.maachang.rimdb.index.numberFloat;

import org.maachang.rimdb.index.WherePointer;

/**
 * Float(double)小なり(<)ポインタ.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class NumberFloatSmall extends WherePointer<Double> {
	protected NumberFloatSmall() {
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            [<=]で検索する場合は[true]をセット.
	 */
	public NumberFloatSmall(NumberFloatIndex index, boolean eq) {
		if (eq) {
			this.type = TYPE_LE;
		} else {
			this.type = TYPE_LT;
		}
		this.columnName = index.getColumnName();
		this.eq = eq;
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            [<=]で検索する場合は[true]をセット.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public NumberFloatSmall(NumberFloatIndex index, boolean eq, double word) {
		this(index, eq);
		set(word);
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            [<=]で検索する場合は[true]をセット.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public NumberFloatSmall(NumberFloatIndex index, boolean eq, Object word) {
		this(index, eq);
		parameter(word);
	}

	/**
	 * 情報セット.
	 * 
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public final void parameter(final Object word) {
		set(NumberFloatIn.convert(word));
	}

	/**
	 * オブジェクトコピー.
	 * 
	 * @param mode
	 *            [true]を設定した場合、パラメータ情報はコピーされません.
	 * @return SearchPointer コピーされたオブジェクトが返却されます.
	 */
	public final NumberFloatSmall copy(final boolean mode) {
		NumberFloatSmall ret = new NumberFloatSmall();
		baseCopy(mode, ret);
		return ret;
	}
}
