package org.maachang.rimdb.index.comparable;

import org.maachang.rimdb.index.WherePointer;

/**
 * Comparable(比較可能なJavaオブジェクト)小なり(<)ポインタ.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
@SuppressWarnings("unchecked")
public final class ComparableSmall extends WherePointer<Comparable> {
	protected ComparableSmall() {
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            [<=]で検索する場合は[true]をセット.
	 */
	public ComparableSmall(ComparableIndex index, boolean eq) {
		if (eq) {
			this.type = TYPE_LE;
		} else {
			this.type = TYPE_LT;
		}
		this.columnName = index.getColumnName();
		this.eq = eq;
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            [<=]で検索する場合は[true]をセット.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public ComparableSmall(ComparableIndex index, boolean eq, Comparable word) {
		this(index, eq);
		set(word);
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            [<=]で検索する場合は[true]をセット.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public ComparableSmall(ComparableIndex index, boolean eq, Object word) {
		this(index, eq);
		parameter(word);
	}

	/**
	 * 情報セット.
	 * 
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public final void parameter(final Object word) {
		set(ComparableIn.convert(word));
	}

	/**
	 * オブジェクトコピー.
	 * 
	 * @param mode
	 *            [true]を設定した場合、パラメータ情報はコピーされません.
	 * @return SearchPointer コピーされたオブジェクトが返却されます.
	 */
	public final ComparableSmall copy(final boolean mode) {
		ComparableSmall ret = new ComparableSmall();
		baseCopy(mode, ret);
		return ret;
	}
}
