package org.maachang.rimdb.index;

/**
 * 行番号ソート情報.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class SortLines implements SortComparable {

	/** 行位置に対するソート位置. **/
	public final int[] list;

	/**
	 * コンストラクタ.
	 * 
	 * @param line
	 *            対象のインデックスに対する行情報を設定します.
	 * @param length
	 *            対象の全体長を設定します.
	 */
	public SortLines(final int[][] line, final int length) {
		int lenJ, j;
		int[] ln;
		final int[] n = new int[length];
		final int len = line.length;
		for (int i = 0; i < len; i++) {
			ln = line[i];
			lenJ = ln.length;
			for (j = 0; j < lenJ; j++) {
				n[ln[j]] = i;
			}
		}
		list = n;
	}

	/**
	 * 比較処理.
	 * 
	 * @param src
	 *            チェック開始条件を設定します.
	 * @param dest
	 *            チェック終了条件を設定します.
	 * @return int 比較結果が返されます.
	 */
	public final int comparable(final int src, final int dest) {
		if (list[src] > list[dest]) {
			return 1;
		} else if (list[src] < list[dest]) {
			return -1;
		}
		return 0;
	}
}
