package org.maachang.rimdb.index;

/**
 * ポインタインターフェイス.
 * 
 * @version 2014/07/13
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public interface Pointer {

	/**
	 * ポインタタイプ : 一致(=).
	 */
	public static final int TYPE_EQ = 1;

	/**
	 * ポインタタイプ : 複数一致(IN).
	 */
	public static final int TYPE_IN = 2;

	/**
	 * ポインタタイプ : 大なり(>).
	 */
	public static final int TYPE_GT = 3;

	/**
	 * ポインタタイプ : 以上(>=).
	 */
	public static final int TYPE_GE = 4;

	/**
	 * ポインタタイプ : 小なり(<).
	 */
	public static final int TYPE_LT = 5;

	/**
	 * ポインタタイプ : 以下(<=).
	 */
	public static final int TYPE_LE = 6;

	/**
	 * ポインタタイプ : 不一致(!= or <>).
	 */
	public static final int TYPE_NE = 7;

	/**
	 * ポインタタイプ : 範囲(BETWEEN).
	 */
	public static final int TYPE_BETWEEN = 8;

	/**
	 * ポインタタイプ : 部分検索(LIKE).
	 */
	public static final int TYPE_LIKE = 9;

	/**
	 * ポインタタイプ : 空間インデックス検索(POINT).
	 */
	public static final int TYPE_POSITION = 10;

	/**
	 * 番号取得.
	 * 
	 * @return int 番号が返却されます.
	 */
	public int getNo();

	/**
	 * 番号設定.
	 * 
	 * @param no
	 *            対象の番号を設定します.
	 */
	public void setNo(int no);

	/**
	 * 情報リセット.
	 * 
	 * @param mode
	 *            [true]を設定した場合、設定ワード条件も削除します.
	 */
	public void reset(boolean mode);

	/**
	 * 情報コピー.
	 * 
	 * @param mode
	 *            [true]を設定した場合、パラメータ情報はコピーされません.
	 * @return Pointer コピーされた情報が返却されます.
	 */
	public Pointer copy(boolean mode);

	/**
	 * 情報セット.
	 * 
	 * @param word
	 *            検索内容を設定します.
	 */
	public void parameter(Object word);

	/**
	 * 処理タイプを取得.
	 * 
	 * @return int 処理タイプが返却されます[TYPE_XXXX].
	 */
	public int getType();

}
