package org.maachang.rimdb;

/**
 * テーブル.
 * 
 * @version 2014/07/07
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public interface Table {

	/**
	 * テーブル利用後のリセット. この処理は、Rowデータなど、アクセスが終了した後に呼び出す必要があります.
	 */
	public void reset();

	/**
	 * テーブル名を取得.
	 * 
	 * @return String テーブル名が返却されます.
	 */
	public String getName();

	/**
	 * 全行数を取得.
	 * 
	 * @return int 行数が返却されます.
	 */
	public int length();

	/**
	 * カラム数を取得.
	 * 
	 * @return int カラム数が返却されます.
	 */
	public int getColumnLength();

	/**
	 * カラム名を取得.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @return String カラム名が返却されます.
	 */
	public String getColumnName(int no);

	/**
	 * 行オブジェクトを取得.
	 * 
	 * @return Row 行情報が返却されます.
	 */
	public Row getRow();

	/**
	 * 行オブジェクトを取得.
	 * 
	 * @param no
	 *            行番号を設定します.
	 * @return Row 行情報が返却されます.
	 */
	public Row getRow(int no);

	/**
	 * 指定カラム項番がユニーク条件かチェック.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @return boolean [true]の場合、ユニーク条件です.
	 */
	public boolean isUnique(int no);

	/**
	 * 指定カラム項番がユニーク条件かチェック.
	 * 
	 * @param name
	 *            対象のカラム名を設定します.
	 * @return boolean [true]の場合、ユニーク条件です.
	 */
	public boolean isUnique(String name);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param value
	 *            検索条件を設定します.
	 * @return int 検索場所が返却されます.
	 */
	public int search(int value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param value
	 *            検索条件を設定します.
	 * @return int 検索場所が返却されます.
	 */
	public int search(long value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param value
	 *            検索条件を設定します.
	 * @return Row 検索位置のRow情報が返却されます.
	 */
	public Row searchRow(int value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param value
	 *            検索条件を設定します.
	 * @return Row 検索位置のRow情報が返却されます.
	 */
	public Row searchRow(long value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @param value
	 *            検索条件を設定します.
	 * @return int 検索場所が返却されます.
	 */
	public int search(int no, int value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @param value
	 *            検索条件を設定します.
	 * @return int 検索場所が返却されます.
	 */
	public int search(int no, long value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @param value
	 *            検索条件を設定します.
	 * @return int 検索場所が返却されます.
	 */
	public int search(String name, int value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @param value
	 *            検索条件を設定します.
	 * @return int 検索場所が返却されます.
	 */
	public int search(String name, long value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @param value
	 *            検索条件を設定します.
	 * @return Row 検索位置のRow情報が返却されます.
	 */
	public Row searchRow(int no, int value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @param value
	 *            検索条件を設定します.
	 * @return Row 検索位置のRow情報が返却されます.
	 */
	public Row searchRow(int no, long value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @param value
	 *            検索条件を設定します.
	 * @return Row 検索位置のRow情報が返却されます.
	 */
	public Row searchRow(String name, int value);

	/**
	 * ユニーク条件を検索.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @param value
	 *            検索条件を設定します.
	 * @return Row 検索位置のRow情報が返却されます.
	 */
	public Row searchRow(String name, long value);

}
