/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import org.maachang.leveldb.JniBuffer;
import org.maachang.leveldb.Leveldb;
import org.maachang.leveldb.LeveldbException;
import org.maachang.leveldb.jni;

public final class WriteBatch {
    protected long addr = jni.leveldb_wb_create();
    protected int count = 0;

    public final void finalize() throws Exception {
        this.close();
    }

    public final void close() {
        if (this.addr != 0L) {
            jni.leveldb_wb_destroy(this.addr);
            this.addr = 0L;
        }
    }

    public final boolean isClose() {
        return this.addr == 0L;
    }

    protected final void check() {
        if (this.addr == 0L) {
            throw new LeveldbException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    public final void put(JniBuffer key, JniBuffer value) {
        this.check();
        if (key == null || value == null || key.position() == 0 || value.position() == 0) {
            throw new LeveldbException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        jni.leveldb_wb_put(this.addr, key.address(), key.position(), value.address(), value.position());
        ++this.count;
    }

    public final void remove(JniBuffer key) {
        this.check();
        if (key == null || key.position() == 0) {
            throw new LeveldbException("\u30ad\u30fc\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        jni.leveldb_wb_remove(this.addr, key.address(), key.position());
        ++this.count;
    }

    public final void write(Leveldb db) {
        this.check();
        if (db == null || db.isClose()) {
            throw new LeveldbException("\u66f8\u304d\u8fbc\u307f\u5148\u306eLeveldb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u308b\u304b\u7121\u52b9\u3067\u3059");
        }
        if (this.count == 0) {
            return;
        }
        if (jni.leveldb_wb_flush(db.addr, this.addr) == -1) {
            throw new LeveldbException("Leveldb\u306b\u5bfe\u3057\u3066\u3001WriteBatch\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }
}

